/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.log.BlockSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogTip {
    private static final byte[] NO_BYTES = new byte[0];
    @NotNull
    final byte[] bytes;
    public final long pageAddress;
    public final int count;
    public final long highAddress;
    public final long approvedHighAddress;
    @NotNull
    final BlockSet.Immutable blockSet;
    @Nullable
    private Iterable<Block> cachedBlocks;

    LogTip(long fileLengthBound) {
        this(fileLengthBound, 0L, 0L);
    }

    LogTip(long fileLengthBound, long pageAddress, long highAddress) {
        this.bytes = NO_BYTES;
        this.pageAddress = pageAddress;
        this.count = -1;
        this.highAddress = this.approvedHighAddress = highAddress;
        this.blockSet = new BlockSet.Immutable(fileLengthBound);
    }

    public LogTip(@NotNull byte[] bytes, long pageAddress, int count, long highAddress, long approvedHighAddress, @NotNull BlockSet.Immutable blockSet) {
        this.bytes = bytes;
        this.pageAddress = pageAddress;
        this.count = count;
        this.highAddress = highAddress;
        this.approvedHighAddress = approvedHighAddress;
        this.blockSet = blockSet;
    }

    public LogTip asTruncatedTo(long highAddress) {
        return new LogTip(this.bytes, this.pageAddress, this.count, highAddress, highAddress, this.blockSet);
    }

    LogTip withApprovedAddress(long updatedApprovedHighAddress) {
        return new LogTip(this.bytes, this.pageAddress, this.count, this.highAddress, updatedApprovedHighAddress, this.blockSet);
    }

    LogTip withResize(int updatedCount, long updatedHighAddress, long updatedApprovedHighAddress, @NotNull BlockSet.Immutable blockSet) {
        return new LogTip(this.bytes, this.pageAddress, updatedCount, updatedHighAddress, updatedApprovedHighAddress, blockSet);
    }

    public long[] getAllFiles() {
        return this.blockSet.getFiles();
    }

    public BlockSet.Mutable getBlockSetCopy() {
        return this.blockSet.beginWrite();
    }

    public LongIterator getFilesFrom(long highAddress) {
        return this.blockSet.getFilesFrom(highAddress);
    }

    @Nullable
    public Iterable<Block> getCachedBlocks() {
        return this.cachedBlocks;
    }

    public void setCachedBlocks(@NotNull Iterable<Block> cachedBlocks) {
        this.cachedBlocks = cachedBlocks;
    }
}

