/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.event;

import javax.faces.component.UIComponent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.apache.myfaces.trinidad.event.RangeChangeListener;

public class RangeChangeEvent
extends FacesEvent {
    private final int _oldStart;
    private final int _oldEnd;
    private final int _newStart;
    private final int _newEnd;
    private static final long serialVersionUID = 1L;

    public RangeChangeEvent(UIComponent source, int oldStart, int oldEnd, int newStart, int newEnd) {
        super(source);
        this._oldStart = oldStart;
        this._oldEnd = oldEnd;
        this._newStart = newStart;
        this._newEnd = newEnd;
    }

    public int getOldStart() {
        return this._oldStart;
    }

    public int getOldEnd() {
        return this._oldEnd;
    }

    public int getNewStart() {
        return this._newStart;
    }

    public int getNewEnd() {
        return this._newEnd;
    }

    public void processListener(FacesListener listener) {
        ((RangeChangeListener)listener).processRangeChange(this);
    }

    public boolean isAppropriateListener(FacesListener listener) {
        return listener instanceof RangeChangeListener;
    }

    public int hashCode() {
        return this._newStart << 4 ^ this.getPhaseId().hashCode() << 8 ^ this.getComponent().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof RangeChangeEvent) {
            RangeChangeEvent that = (RangeChangeEvent)((Object)o);
            return this._newStart == that._newStart && this._newEnd == that._newEnd && this._oldStart == that._oldStart && this._oldEnd == that._oldEnd && this.getComponent().equals(that.getComponent()) && this.getPhaseId().equals(that.getPhaseId());
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(((Object)((Object)this)).getClass().getName());
        sb.append("[phaseId=");
        sb.append(this.getPhaseId());
        sb.append(",component=");
        sb.append(this.getComponent());
        sb.append(",newStart=");
        sb.append(this.getNewStart());
        sb.append(",newEnd=");
        sb.append(this.getNewEnd());
        sb.append(",oldStart=");
        sb.append(this.getOldStart());
        sb.append(",oldEnd=");
        sb.append(this.getOldEnd());
        sb.append(']');
        return sb.toString();
    }
}

