/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeLabel;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeListbox;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNode;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeSelect;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeListboxRenderer<T extends AbstractUITreeListbox>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(TreeListboxRenderer.class);

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        this.decodeState(facesContext, (AbstractUITree)component);
    }

    @Override
    public void encodeChildrenInternal(FacesContext context, T component) throws IOException {
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        Markup markup = component.getMarkup();
        writer.startElement(HtmlElements.TOBAGO_TREE_LISTBOX);
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeAttribute(DataAttributes.SELECTION_MODE, ((AbstractUIData)component).getSelectable().name(), false);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeNameAttribute(clientId + "::" + "selected");
        writer.writeIdAttribute(clientId + "::" + "selected");
        writer.writeAttribute(HtmlAttributes.VALUE, this.encodeState((AbstractUITreeListbox)component), false);
        writer.endElement(HtmlElements.INPUT);
        ArrayList<Integer> thisLevel = new ArrayList<Integer>();
        thisLevel.add(0);
        ArrayList<Integer> nextLevel = new ArrayList<Integer>();
        Integer size = ((AbstractUITreeListbox)component).getSize();
        size = Math.max(size != null ? size : 10, 2);
        int depth = ((AbstractUIData)component).getTreeDataModel().getDepth();
        if (depth < 0) {
            depth = 7;
            LOG.warn("No depth, set to {}!", (Object)depth);
        }
        for (int level = 0; level < depth; ++level) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(TobagoClass.LEVEL);
            if (level > 0) {
                writer.startElement(HtmlElements.SELECT);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, true);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
                writer.writeClassAttribute(TobagoClass.SELECTED);
                writer.endElement(HtmlElements.SELECT);
            }
            for (Integer rowIndex : thisLevel) {
                this.encodeSelectBox(facesContext, (AbstractUITreeListbox)component, writer, rowIndex, (List<Integer>)nextLevel, size);
            }
            thisLevel.clear();
            ArrayList<Integer> swap = thisLevel;
            thisLevel = nextLevel;
            nextLevel = swap;
            writer.endElement(HtmlElements.DIV);
        }
        writer.endElement(HtmlElements.TOBAGO_TREE_LISTBOX);
        component.setRowIndex(-1);
    }

    private void encodeSelectBox(FacesContext facesContext, AbstractUITreeListbox tree, TobagoResponseWriter writer, int parentRowIndex, List<Integer> foldersRowIndices, int size) throws IOException {
        AbstractUITreeLabel label;
        tree.setRowIndex(parentRowIndex);
        AbstractUITreeNode node = ComponentUtils.findDescendant((UIComponent)tree, AbstractUITreeNode.class);
        String parentId = node.getClientId(facesContext);
        writer.startElement(HtmlElements.SELECT);
        writer.writeClassAttribute(TobagoClass.SELECTED);
        writer.writeIdAttribute(parentId + "::" + "parent");
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
        AbstractUITreeSelect select = ComponentUtils.findDescendant((UIComponent)tree, AbstractUITreeSelect.class);
        String labelValue = select != null ? select.getLabel() : ((label = ComponentUtils.findDescendant((UIComponent)tree, AbstractUITreeLabel.class)) != null ? label.getLabel() : null);
        if (labelValue != null) {
            writer.startElement(HtmlElements.OPTGROUP);
            writer.writeAttribute(HtmlAttributes.LABEL, labelValue, true);
            writer.endElement(HtmlElements.OPTGROUP);
        }
        List<Integer> rowIndices = tree.getRowIndicesOfChildren();
        for (Integer rowIndex : rowIndices) {
            tree.setRowIndex(rowIndex);
            if (!tree.isRowAvailable()) break;
            for (UIComponent child : tree.getChildren()) {
                child.encodeAll(facesContext);
            }
            if (!tree.isFolder()) continue;
            foldersRowIndices.add(rowIndex);
        }
        writer.endElement(HtmlElements.SELECT);
    }

    private void decodeState(FacesContext facesContext, AbstractUITree tree) {
        String hiddenInputId = tree.getClientId(facesContext) + "::" + "selected";
        String selectedIndicesString = (String)facesContext.getExternalContext().getRequestParameterMap().get(hiddenInputId);
        List<Integer> selectedIndices = JsonUtils.decodeIntegerArray(selectedIndicesString);
        SelectedState selectedState = tree.getSelectedState();
        int last = tree.isRowsUnlimited() ? Integer.MAX_VALUE : tree.getFirst() + tree.getRows();
        for (int rowIndex = tree.getFirst(); rowIndex < last; ++rowIndex) {
            tree.setRowIndex(rowIndex);
            if (!tree.isRowAvailable()) break;
            TreePath path = tree.getPath();
            if (selectedIndices != null && selectedIndices.equals(JsonUtils.decodeIntegerArray(path.toString()))) {
                selectedState.select(path);
                continue;
            }
            selectedState.unselect(path);
        }
        tree.setRowIndex(-1);
    }

    private String encodeState(AbstractUITreeListbox tree) {
        SelectedState selectedState = tree.getSelectedState();
        int last = tree.isRowsUnlimited() ? Integer.MAX_VALUE : tree.getFirst() + tree.getRows();
        for (int rowIndex = tree.getFirst(); rowIndex < last; ++rowIndex) {
            tree.setRowIndex(rowIndex);
            if (!tree.isRowAvailable()) break;
            TreePath path = tree.getPath();
            if (!selectedState.isSelected(path)) continue;
            return path.toString();
        }
        tree.setRowIndex(-1);
        return JsonUtils.encodeEmptyArray();
    }
}

