/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestViewContext {
    public static final String VIEW_CONTEXT_KEY = "oam.VIEW_CONTEXT";
    public static final String RESOURCE_DEPENDENCY_INSPECTED_CLASS = "oam.RDClass";
    private static final String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";
    private Map<ResourceDependency, Boolean> addedResources;
    private Map<Class<?>, Boolean> processedClasses = new HashMap();
    private Map<String, Boolean> renderTargetMap = null;

    public static RequestViewContext getCurrentInstance() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        return RequestViewContext.getCurrentInstance(ctx);
    }

    public static RequestViewContext getCurrentInstance(FacesContext ctx) {
        return RequestViewContext.getCurrentInstance(ctx, ctx.getViewRoot());
    }

    public static RequestViewContext getCurrentInstance(FacesContext ctx, UIViewRoot root) {
        HashMap<UIViewRoot, RequestViewContext> map = (HashMap<UIViewRoot, RequestViewContext>)ctx.getAttributes().get(VIEW_CONTEXT_KEY);
        RequestViewContext rvc = null;
        if (map == null) {
            map = new HashMap<UIViewRoot, RequestViewContext>();
            rvc = new RequestViewContext();
            map.put(root, rvc);
            ctx.getAttributes().put(VIEW_CONTEXT_KEY, map);
            return rvc;
        }
        rvc = (RequestViewContext)map.get(root);
        if (rvc == null) {
            rvc = new RequestViewContext();
            map.put(root, rvc);
        }
        return rvc;
    }

    public boolean isResourceDependencyAlreadyProcessed(ResourceDependency dependency) {
        if (this.addedResources == null) {
            return false;
        }
        return this.addedResources.containsKey(dependency);
    }

    public void setResourceDependencyAsProcessed(ResourceDependency dependency) {
        if (this.addedResources == null) {
            this.addedResources = new HashMap<ResourceDependency, Boolean>();
        }
        this.addedResources.put(dependency, true);
    }

    public boolean isClassAlreadyProcessed(Class<?> inspectedClass) {
        return this.processedClasses.containsKey(inspectedClass);
    }

    public void setClassProcessed(Class<?> inspectedClass) {
        this.processedClasses.put(inspectedClass, Boolean.TRUE);
    }

    public boolean isRenderTarget(String target) {
        if (this.renderTargetMap != null) {
            return Boolean.TRUE.equals(this.renderTargetMap.get(target));
        }
        return false;
    }

    public void setRenderTarget(String target, boolean value) {
        if (this.renderTargetMap == null) {
            this.renderTargetMap = new HashMap<String, Boolean>(8);
        }
        this.renderTargetMap.put(target, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRequestViewContext(FacesContext facesContext, UIViewRoot root) {
        for (Map.Entry entry : root.getFacets().entrySet()) {
            UIComponent facet = (UIComponent)entry.getValue();
            if (facet.getId() == null || !facet.getId().startsWith("javax_faces_location_")) continue;
            try {
                facesContext.getAttributes().put(SKIP_ITERATION_HINT, Boolean.TRUE);
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, null);
                facet.visitTree(visitContext, (VisitCallback)new RefreshViewContext());
            }
            finally {
                facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
            }
        }
    }

    private class RefreshViewContext
    implements VisitCallback {
        private RefreshViewContext() {
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            Class inspectedClass = (Class)target.getAttributes().get(RequestViewContext.RESOURCE_DEPENDENCY_INSPECTED_CLASS);
            if (inspectedClass != null) {
                RequestViewContext.this.setClassProcessed(inspectedClass);
            }
            return VisitResult.ACCEPT;
        }
    }
}

