/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.scm.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import org.codehaus.plexus.util.cli.StreamConsumer;

/**
 * @author <a href="mailto:davide.angelocola+apache@gmail.com">Davide Angelocola</a>
 */
public class ConsumerUtils {

    private ConsumerUtils() {}

    /**
     * Read file f, sending each line to the consumer.
     *
     * @param f TODO
     * @param consumer TODO
     * @throws IOException if any
     */
    public static void consumeFile(File f, StreamConsumer consumer) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(f));

        try {
            String line;
            while ((line = r.readLine()) != null) {
                consumer.consumeLine(line);
            }

        } finally {
            r.close();
        }
    }
}
