/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.internal.transformation.OnChangeTransformer;

abstract class TransformedArtifact
extends DefaultArtifact {
    private final OnChangeTransformer onChangeTransformer;
    private static final int BUFFER_SIZE = 8192;

    TransformedArtifact(Artifact source, Supplier<Path> sourcePathProvider, String classifier, String extension, Path targetPath, BiConsumer<Path, Path> transformerConsumer) {
        super(source.getGroupId(), source.getArtifactId(), source.getVersionRange(), source.getScope(), extension, classifier, (ArtifactHandler)new TransformedArtifactHandler(classifier, extension, source.getArtifactHandler().getPackaging()));
        this.onChangeTransformer = new OnChangeTransformer(sourcePathProvider, targetPath, TransformedArtifact::sha1, transformerConsumer);
    }

    public boolean isResolved() {
        return this.getFile() != null;
    }

    public void setFile(File file) {
        throw new IllegalStateException("transformed artifact file cannot be set");
    }

    public File getFile() {
        Path result = this.onChangeTransformer.get();
        if (result == null) {
            return null;
        }
        return result.toFile();
    }

    private static String sha1(Path path) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = fis.read(buffer)) != -1) {
                    md.update(buffer, 0, read);
                }
            }
            StringBuilder result = new StringBuilder();
            for (byte b : md.digest()) {
                result.append(String.format("%02x", b));
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class TransformedArtifactHandler
    implements ArtifactHandler {
        private final String classifier;
        private final String extension;
        private final String packaging;

        private TransformedArtifactHandler(String classifier, String extension, String packaging) {
            this.classifier = classifier;
            this.extension = Objects.requireNonNull(extension);
            this.packaging = Objects.requireNonNull(packaging);
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getDirectory() {
            return null;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getLanguage() {
            return "none";
        }

        public String getPackaging() {
            return this.packaging;
        }

        public boolean isAddedToClasspath() {
            return false;
        }

        public boolean isIncludesDependencies() {
            return false;
        }
    }
}

