/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.feature.Features;
import org.apache.maven.internal.transformation.TransformedArtifact;
import org.apache.maven.model.building.DefaultBuildPomXMLFilterFactory;
import org.apache.maven.model.building.TransformerContext;
import org.apache.maven.model.transform.BuildToRawPomXMLFilterFactory;
import org.apache.maven.model.transform.RawToConsumerPomXMLFilterFactory;
import org.apache.maven.model.transform.pull.XmlUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.installation.InstallRequest;

@Singleton
@Named(value="consumer-pom")
public final class ConsumerPomArtifactTransformer {
    private static final String CONSUMER_POM_CLASSIFIER = "consumer";

    public void injectTransformedArtifacts(MavenProject project, RepositorySystemSession session) throws IOException {
        if (this.isActive(session)) {
            Path generatedFile;
            String buildDirectory;
            String string = buildDirectory = project.getBuild() != null ? project.getBuild().getDirectory() : null;
            if (buildDirectory == null) {
                generatedFile = Files.createTempFile(CONSUMER_POM_CLASSIFIER, "pom", new FileAttribute[0]);
            } else {
                Path buildDir = Paths.get(buildDirectory, new String[0]);
                Files.createDirectories(buildDir, new FileAttribute[0]);
                generatedFile = Files.createTempFile(buildDir, CONSUMER_POM_CLASSIFIER, "pom", new FileAttribute[0]);
            }
            project.addAttachedArtifact((org.apache.maven.artifact.Artifact)new ConsumerPomArtifact(project, generatedFile, session));
        }
    }

    public InstallRequest remapInstallArtifacts(RepositorySystemSession session, InstallRequest request) {
        if (this.isActive(session) && this.consumerPomPresent(request.getArtifacts())) {
            request.setArtifacts(this.replacePom(request.getArtifacts()));
        }
        return request;
    }

    public DeployRequest remapDeployArtifacts(RepositorySystemSession session, DeployRequest request) {
        if (this.isActive(session) && this.consumerPomPresent(request.getArtifacts())) {
            request.setArtifacts(this.replacePom(request.getArtifacts()));
        }
        return request;
    }

    private boolean isActive(RepositorySystemSession session) {
        return Features.buildConsumer((Map)session.getUserProperties()).isActive();
    }

    private boolean consumerPomPresent(Collection<Artifact> artifacts) {
        return artifacts.stream().anyMatch(a -> CONSUMER_POM_CLASSIFIER.equals(a.getClassifier()));
    }

    private Collection<Artifact> replacePom(Collection<Artifact> artifacts) {
        ArrayList<Artifact> result = new ArrayList<Artifact>(artifacts.size());
        for (Artifact artifact : artifacts) {
            if (CONSUMER_POM_CLASSIFIER.equals(artifact.getClassifier())) {
                DefaultArtifact remapped = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "", artifact.getExtension(), artifact.getVersion(), artifact.getProperties(), artifact.getFile());
                result.add((Artifact)remapped);
                continue;
            }
            if ("".equals(artifact.getClassifier()) && artifact.getExtension().equals("pom") || artifact.getExtension().startsWith("pom.")) continue;
            result.add(artifact);
        }
        return result;
    }

    static InputStream transform(Path pomFile, TransformerContext context) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)Files.newInputStream(pomFile, new OpenOption[0]));
        MXParser parser = new MXParser(EntityReplacementMap.defaultEntityReplacementMap);
        parser.setInput((Reader)reader);
        parser = new RawToConsumerPomXMLFilterFactory((BuildToRawPomXMLFilterFactory)new DefaultBuildPomXMLFilterFactory(context, true)).get((XmlPullParser)parser, pomFile);
        return XmlUtils.writeDocument((XmlStreamReader)reader, (XmlPullParser)parser);
    }

    private static class ConsumerPomArtifact
    extends TransformedArtifact {
        private ConsumerPomArtifact(MavenProject mavenProject, Path target, RepositorySystemSession session) {
            super((org.apache.maven.artifact.Artifact)new ProjectArtifact(mavenProject), () -> mavenProject.getFile().toPath(), ConsumerPomArtifactTransformer.CONSUMER_POM_CLASSIFIER, "pom", target, ConsumerPomArtifact.transformer(session));
        }

        private static BiConsumer<Path, Path> transformer(RepositorySystemSession session) {
            TransformerContext context = (TransformerContext)session.getData().get(TransformerContext.KEY);
            return (src, dest) -> {
                try (InputStream inputStream = ConsumerPomArtifactTransformer.transform(src, context);){
                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                    Files.copy(inputStream, dest, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException | XmlPullParserException e) {
                    throw new RuntimeException(e);
                }
            };
        }
    }
}

