/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.internal.impl.DefaultArtifact;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.project.MavenProject;

@Named
@SessionScoped
public class DefaultArtifactManager
implements ArtifactManager {
    @Nonnull
    private final DefaultSession session;
    private final Map<String, Path> paths = new ConcurrentHashMap<String, Path>();

    @Inject
    public DefaultArtifactManager(@Nonnull DefaultSession session) {
        this.session = session;
    }

    @Nonnull
    public Optional<Path> getPath(@Nonnull org.apache.maven.api.Artifact artifact) {
        File file;
        Path path;
        String id = this.id(artifact);
        if (this.session.getMavenSession().getAllProjects() != null) {
            for (MavenProject project : this.session.getMavenSession().getAllProjects()) {
                if (!id.equals(this.id(project.getArtifact())) || project.getArtifact().getFile() == null) continue;
                return Optional.of(project.getArtifact().getFile().toPath());
            }
        }
        if ((path = this.paths.get(id)) == null && artifact instanceof DefaultArtifact && (file = ((DefaultArtifact)artifact).getArtifact().getFile()) != null) {
            path = file.toPath();
        }
        return Optional.ofNullable(path);
    }

    public void setPath(@Nonnull org.apache.maven.api.Artifact artifact, Path path) {
        String id = this.id(artifact);
        if (this.session.getMavenSession().getAllProjects() != null) {
            for (MavenProject project : this.session.getMavenSession().getAllProjects()) {
                if (!id.equals(this.id(project.getArtifact()))) continue;
                project.getArtifact().setFile(path != null ? path.toFile() : null);
                break;
            }
        }
        if (path == null) {
            this.paths.remove(id);
        } else {
            this.paths.put(id, path);
        }
    }

    private String id(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + (artifact.getClassifier() == null || artifact.getClassifier().isEmpty() ? "" : ":" + artifact.getClassifier()) + ":" + artifact.getVersion();
    }

    private String id(org.apache.maven.api.Artifact artifact) {
        return artifact.key();
    }
}

