/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.transform;

import java.util.List;
import java.util.function.Function;
import org.apache.maven.model.transform.pull.BufferingParser;
import org.apache.maven.model.transform.pull.NodeBufferingParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

class CiFriendlyXMLFilter
extends NodeBufferingParser {
    private final boolean replace;
    private Function<String, String> replaceChain = Function.identity();

    CiFriendlyXMLFilter(XmlPullParser xmlPullParser, boolean replace) {
        super(xmlPullParser, "version");
        this.replace = replace;
    }

    public CiFriendlyXMLFilter setChangelist(String changelist) {
        this.replaceChain = this.replaceChain.andThen(t -> t.replace("${changelist}", changelist));
        return this;
    }

    public CiFriendlyXMLFilter setRevision(String revision) {
        this.replaceChain = this.replaceChain.andThen(t -> t.replace("${revision}", revision));
        return this;
    }

    public CiFriendlyXMLFilter setSha1(String sha1) {
        this.replaceChain = this.replaceChain.andThen(t -> t.replace("${sha1}", sha1));
        return this;
    }

    public boolean isSet() {
        return !this.replaceChain.equals(Function.identity());
    }

    @Override
    protected void process(List<BufferingParser.Event> buffer) {
        for (BufferingParser.Event event : buffer) {
            if (event.event == 4 && this.replace && event.text.contains("${")) {
                event.text = this.replaceChain.apply(event.text);
            }
            this.pushEvent(event);
        }
    }
}

