/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.jdk;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.AbstractTransporter;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.jdk.JdkException;
import org.eclipse.aether.transport.jdk.JdkTransporterFactory;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdkTransporter
extends AbstractTransporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkTransporter.class);
    private static final DateTimeFormatter RFC7231 = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT"));
    private static final int MULTIPLE_CHOICES = 300;
    private static final int NOT_FOUND = 404;
    private static final int PRECONDITION_FAILED = 412;
    private static final long MODIFICATION_THRESHOLD = 60000L;
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_RANGE = "Content-Range";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String RANGE = "Range";
    private static final String USER_AGENT = "User-Agent";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final Pattern CONTENT_RANGE_PATTERN = Pattern.compile("\\s*bytes\\s+([0-9]+)\\s*-\\s*([0-9]+)\\s*/.*");
    private final URI baseUri;
    private final HttpClient client;
    private final Map<String, String> headers;
    private final int requestTimeout;
    private final Boolean expectContinue;
    static final String HTTP_INSTANCE_KEY_PREFIX = JdkTransporterFactory.class.getName() + ".http.";

    JdkTransporter(RepositorySystemSession session, RemoteRepository repository, int javaVersion) throws NoTransporterException {
        Map configuredHeaders;
        try {
            URI uri = new URI(repository.getUrl()).parseServerAuthority();
            if (uri.isOpaque()) {
                throw new URISyntaxException(repository.getUrl(), "URL must not be opaque");
            }
            if (uri.getRawFragment() != null || uri.getRawQuery() != null) {
                throw new URISyntaxException(repository.getUrl(), "URL must not have fragment or query");
            }
            Object path = uri.getPath();
            if (path == null) {
                path = "/";
            }
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            this.baseUri = URI.create(uri.getScheme() + "://" + uri.getRawAuthority() + (String)path);
        }
        catch (URISyntaxException e) {
            throw new NoTransporterException(repository, e.getMessage(), (Throwable)e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        String userAgent = ConfigUtils.getString((RepositorySystemSession)session, (String)"Aether", (String[])new String[]{"aether.transport.http.userAgent"});
        if (userAgent != null) {
            headers.put(USER_AGENT, userAgent);
        }
        if ((configuredHeaders = ConfigUtils.getMap((RepositorySystemSession)session, Collections.emptyMap(), (String[])new String[]{"aether.transport.http.headers." + repository.getId(), "aether.transport.http.headers"})) != null) {
            configuredHeaders.forEach((k, v) -> headers.put(String.valueOf(k), v != null ? String.valueOf(v) : null));
        }
        headers.put(CACHE_CONTROL, "no-cache, no-store");
        this.requestTimeout = ConfigUtils.getInteger((RepositorySystemSession)session, (int)1800000, (String[])new String[]{"aether.transport.http.requestTimeout." + repository.getId(), "aether.transport.http.requestTimeout"});
        String expectContinueConf = ConfigUtils.getString((RepositorySystemSession)session, null, (String[])new String[]{"aether.transport.http.expectContinue." + repository.getId(), "aether.transport.http.expectContinue"});
        if (javaVersion > 19) {
            this.expectContinue = expectContinueConf == null ? null : Boolean.valueOf(Boolean.parseBoolean(expectContinueConf));
        } else {
            this.expectContinue = null;
            if (expectContinueConf != null) {
                LOGGER.warn("Configuration for Expect-Continue set but is ignored on Java versions below 20 (current java version is {}) due https://bugs.openjdk.org/browse/JDK-8286171", (Object)javaVersion);
            }
        }
        this.headers = headers;
        this.client = this.getOrCreateClient(session, repository);
    }

    private URI resolve(TransportTask task) {
        return this.baseUri.resolve(task.getLocation());
    }

    private ConnectException enhance(ConnectException connectException) {
        ConnectException result = new ConnectException("Connection to " + this.baseUri.toASCIIString() + " refused");
        result.initCause(connectException);
        return result;
    }

    public int classify(Throwable error) {
        if (error instanceof JdkException && ((JdkException)error).getStatusCode() == 404) {
            return 1;
        }
        return 0;
    }

    protected void implPeek(PeekTask task) throws Exception {
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(this.resolve((TransportTask)task)).timeout(Duration.ofMillis(this.requestTimeout)).method("HEAD", HttpRequest.BodyPublishers.noBody());
        this.headers.forEach(request::setHeader);
        try {
            HttpResponse<Void> response = this.client.send(request.build(), HttpResponse.BodyHandlers.discarding());
            if (response.statusCode() >= 300) {
                throw new JdkException(response.statusCode());
            }
        }
        catch (ConnectException e) {
            throw this.enhance(e);
        }
    }

    /*
     * Exception decompiling
     */
    protected void implGet(GetTask task) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[UNCONDITIONALDOLOOP]], but top level block is 40[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void implPut(PutTask task) throws Exception {
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(this.resolve((TransportTask)task)).timeout(Duration.ofMillis(this.requestTimeout));
        if (this.expectContinue != null) {
            request = request.expectContinue(this.expectContinue);
        }
        this.headers.forEach(request::setHeader);
        try (FileUtils.TempFile tempFile = FileUtils.newTempFile();){
            this.utilPut(task, Files.newOutputStream(tempFile.getPath(), new OpenOption[0]), true);
            request.method("PUT", HttpRequest.BodyPublishers.ofFile(tempFile.getPath()));
            try {
                HttpResponse<Void> response = this.client.send(request.build(), HttpResponse.BodyHandlers.discarding());
                if (response.statusCode() >= 300) {
                    throw new JdkException(response.statusCode());
                }
            }
            catch (ConnectException e) {
                throw this.enhance(e);
            }
        }
    }

    protected void implClose() {
    }

    private Map<String, String> extractXChecksums(HttpResponse<?> response) {
        HashMap<String, String> result = new HashMap<String, String>();
        String value = response.headers().firstValue("x-checksum-sha1").orElse(null);
        if (value != null) {
            result.put("SHA-1", value);
        }
        if ((value = (String)response.headers().firstValue("x-checksum-md5").orElse(null)) != null) {
            result.put("MD5", value);
        }
        if (!result.isEmpty()) {
            return result;
        }
        value = response.headers().firstValue("x-goog-meta-checksum-sha1").orElse(null);
        if (value != null) {
            result.put("SHA-1", value);
        }
        if ((value = (String)response.headers().firstValue("x-goog-meta-checksum-md5").orElse(null)) != null) {
            result.put("MD5", value);
        }
        return result.isEmpty() ? null : result;
    }

    private Map<String, String> extractNexus2Checksums(HttpResponse<?> response) {
        String etag = response.headers().firstValue("ETag").orElse(null);
        if (etag != null) {
            int start = etag.indexOf("SHA1{");
            int end = etag.indexOf("}", start + 5);
            if (start >= 0 && end > start) {
                return Collections.singletonMap("SHA-1", etag.substring(start + 5, end));
            }
        }
        return null;
    }

    private InetAddress getHttpLocalAddress(RepositorySystemSession session, RemoteRepository repository) {
        String bindAddress = ConfigUtils.getString((RepositorySystemSession)session, null, (String[])new String[]{"aether.transport.http.localAddress." + repository.getId(), "aether.transport.http.localAddress"});
        if (bindAddress == null) {
            return null;
        }
        try {
            return InetAddress.getByName(bindAddress);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException("Given bind address (" + bindAddress + ") cannot be resolved for remote repository " + String.valueOf(repository), uhe);
        }
    }

    private HttpClient getOrCreateClient(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        String instanceKey = HTTP_INSTANCE_KEY_PREFIX + repository.getId();
        try {
            return (HttpClient)session.getData().computeIfAbsent((Object)instanceKey, () -> {
                final HashMap<Authenticator.RequestorType, PasswordAuthentication> authentications = new HashMap<Authenticator.RequestorType, PasswordAuthentication>();
                SSLContext sslContext = null;
                try {
                    HttpClient result;
                    try (AuthenticationContext repoAuthContext = AuthenticationContext.forRepository((RepositorySystemSession)session, (RemoteRepository)repository);){
                        if (repoAuthContext != null) {
                            sslContext = (SSLContext)repoAuthContext.get("ssl.context", SSLContext.class);
                            String username = repoAuthContext.get("username");
                            String password = repoAuthContext.get("password");
                            authentications.put(Authenticator.RequestorType.SERVER, new PasswordAuthentication(username, password.toCharArray()));
                        }
                    }
                    if (sslContext == null) {
                        sslContext = SSLContext.getDefault();
                    }
                    int connectTimeout = ConfigUtils.getInteger((RepositorySystemSession)session, (int)10000, (String[])new String[]{"aether.transport.http.connectTimeout." + repository.getId(), "aether.transport.http.connectTimeout"});
                    HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.valueOf(ConfigUtils.getString((RepositorySystemSession)session, (String)"HTTP_2", (String[])new String[]{"aether.transport.jdk.httpVersion." + repository.getId(), "aether.transport.jdk.httpVersion"}))).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMillis(connectTimeout)).sslContext(sslContext);
                    this.setLocalAddress(builder, () -> this.getHttpLocalAddress(session, repository));
                    if (repository.getProxy() != null) {
                        ProxySelector proxy = ProxySelector.of(new InetSocketAddress(repository.getProxy().getHost(), repository.getProxy().getPort()));
                        builder.proxy(proxy);
                        try (AuthenticationContext proxyAuthContext = AuthenticationContext.forProxy((RepositorySystemSession)session, (RemoteRepository)repository);){
                            if (proxyAuthContext != null) {
                                String username = proxyAuthContext.get("username");
                                String password = proxyAuthContext.get("password");
                                authentications.put(Authenticator.RequestorType.PROXY, new PasswordAuthentication(username, password.toCharArray()));
                            }
                        }
                    }
                    if (!authentications.isEmpty()) {
                        builder.authenticator(new Authenticator(){

                            @Override
                            protected PasswordAuthentication getPasswordAuthentication() {
                                return (PasswordAuthentication)authentications.get((Object)this.getRequestorType());
                            }
                        });
                    }
                    if (!session.addOnSessionEndedHandler(() -> this.lambda$getOrCreateClient$2(result = builder.build()))) {
                        LOGGER.warn("Using Resolver 2 feature without Resolver 2 session handling, you may leak resources.");
                    }
                    return result;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new WrapperEx(e);
                }
            });
        }
        catch (WrapperEx e) {
            throw new NoTransporterException(repository, e.getCause());
        }
    }

    private void setLocalAddress(HttpClient.Builder builder, Supplier<InetAddress> addressSupplier) {
        try {
            InetAddress address = addressSupplier.get();
            if (address == null) {
                return;
            }
            Method mtd = builder.getClass().getDeclaredMethod("localAddress", InetAddress.class);
            if (!mtd.canAccess(builder)) {
                mtd.setAccessible(true);
            }
            mtd.invoke((Object)builder, address);
        }
        catch (NoSuchMethodException address) {
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private /* synthetic */ void lambda$getOrCreateClient$2(HttpClient result) {
        if (result instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.client).close();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static final class WrapperEx
    extends RuntimeException {
        private WrapperEx(Throwable cause) {
            super(cause);
        }
    }
}

