/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Repository;
import org.apache.maven.internal.transformation.impl.ConsumerPomBuilder;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.TransformerContextBuilder;
import org.apache.maven.model.composition.DependencyManagementImporter;
import org.apache.maven.model.inheritance.InheritanceAssembler;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.management.DependencyManagementInjector;
import org.apache.maven.model.management.PluginManagementInjector;
import org.apache.maven.model.normalization.ModelNormalizer;
import org.apache.maven.model.path.ModelPathTranslator;
import org.apache.maven.model.path.ModelUrlNormalizer;
import org.apache.maven.model.plugin.LifecycleBindingsInjector;
import org.apache.maven.model.plugin.PluginConfigurationExpander;
import org.apache.maven.model.plugin.ReportConfigurationExpander;
import org.apache.maven.model.profile.DefaultProfileSelector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileInjector;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.superpom.SuperPomProvider;
import org.apache.maven.model.v4.MavenModelVersion;
import org.apache.maven.model.validation.ModelValidator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectModelResolver;
import org.apache.maven.repository.internal.ModelCacheFactory;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class DefaultConsumerPomBuilder
implements ConsumerPomBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConsumerPomBuilder.class);
    private static final String BOM_PACKAGING = "bom";
    public static final String POM_PACKAGING = "pom";
    @Inject
    PlexusContainer container;
    @Inject
    ModelCacheFactory modelCacheFactory;

    DefaultConsumerPomBuilder() {
    }

    @Override
    public Model build(RepositorySystemSession session, MavenProject project, Path src) throws ModelBuildingException, ComponentLookupException {
        Model model = project.getModel().getDelegate();
        String packaging = model.getPackaging();
        String originalPackaging = project.getOriginalModel().getPackaging();
        if (POM_PACKAGING.equals(packaging) && !BOM_PACKAGING.equals(originalPackaging)) {
            return this.buildPom(session, project, src);
        }
        return this.buildNonPom(session, project, src);
    }

    protected Model buildPom(RepositorySystemSession session, MavenProject project, Path src) throws ModelBuildingException, ComponentLookupException {
        ModelBuildingResult result = this.buildModel(session, project, src);
        Model model = result.getRawModel().getDelegate();
        return DefaultConsumerPomBuilder.transform(model, project);
    }

    protected Model buildNonPom(RepositorySystemSession session, MavenProject project, Path src) throws ModelBuildingException, ComponentLookupException {
        ModelBuildingResult result = this.buildModel(session, project, src);
        Model model = result.getEffectiveModel().getDelegate();
        return DefaultConsumerPomBuilder.transform(model, project);
    }

    private ModelBuildingResult buildModel(RepositorySystemSession session, MavenProject project, Path src) throws ModelBuildingException, ComponentLookupException {
        DefaultProfileSelector customSelector = new DefaultProfileSelector(){

            public List<Profile> getActiveProfilesV4(Collection<Profile> profiles, ProfileActivationContext context, ModelProblemCollector problems) {
                return new ArrayList<Profile>();
            }
        };
        DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().setProfileSelector((ProfileSelector)customSelector).setProfileInjector(this.lookup(ProfileInjector.class)).setInheritanceAssembler(this.lookup(InheritanceAssembler.class)).setDependencyManagementImporter(this.lookup(DependencyManagementImporter.class)).setDependencyManagementInjector(this.lookup(DependencyManagementInjector.class)).setLifecycleBindingsInjector(this.lookup(LifecycleBindingsInjector.class)).setModelInterpolator(this.lookup(ModelInterpolator.class)).setModelNormalizer(this.lookup(ModelNormalizer.class)).setModelPathTranslator(this.lookup(ModelPathTranslator.class)).setModelProcessor(this.lookup(ModelProcessor.class)).setModelUrlNormalizer(this.lookup(ModelUrlNormalizer.class)).setModelValidator(this.lookup(ModelValidator.class)).setPluginConfigurationExpander(this.lookup(PluginConfigurationExpander.class)).setPluginManagementInjector(this.lookup(PluginManagementInjector.class)).setReportConfigurationExpander(this.lookup(ReportConfigurationExpander.class)).setSuperPomProvider(this.lookup(SuperPomProvider.class)).newInstance();
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        try {
            request.setRootDirectory(project.getRootDirectory());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        request.setPomFile(src.toFile());
        request.setValidationLevel(0);
        request.setLocationTracking(false);
        request.setModelResolver((ModelResolver)new ProjectModelResolver(session, new RequestTrace(null), this.lookup(RepositorySystem.class), this.lookup(RemoteRepositoryManager.class), project.getRemoteProjectRepositories(), ProjectBuildingRequest.RepositoryMerging.POM_DOMINANT, null));
        request.setTransformerContextBuilder((TransformerContextBuilder)modelBuilder.newTransformerContextBuilder());
        request.setSystemProperties(this.toProperties(session.getSystemProperties()));
        request.setUserProperties(this.toProperties(session.getUserProperties()));
        request.setModelCache(this.modelCacheFactory.createCache(session));
        return modelBuilder.build((ModelBuildingRequest)request);
    }

    private Properties toProperties(Map<String, String> map) {
        Properties props = new Properties();
        props.putAll(map);
        return props;
    }

    private <T> T lookup(Class<T> clazz) throws ComponentLookupException {
        return (T)this.container.lookup(clazz);
    }

    static Model transform(Model model, MavenProject project) {
        String packaging = model.getPackaging();
        if (POM_PACKAGING.equals(packaging)) {
            if ((model = model.withRoot(false).withModules(null)).getParent() != null) {
                model = model.withParent(model.getParent().withRelativePath(null));
            }
            if (!model.isPreserveModelVersion()) {
                model = model.withPreserveModelVersion(false);
                String modelVersion = new MavenModelVersion().getModelVersion(model);
                model = model.withModelVersion(modelVersion);
            }
        } else if (BOM_PACKAGING.equals(packaging)) {
            DependencyManagement dependencyManagement = project.getOriginalModel().getDependencyManagement().getDelegate();
            ArrayList dependencies = new ArrayList();
            String version = model.getVersion();
            dependencyManagement.getDependencies().forEach(dependency -> dependencies.add(dependency.withVersion(version)));
            Model.Builder builder = DefaultConsumerPomBuilder.prune(Model.newBuilder((Model)model, (boolean)true).preserveModelVersion(false).root(false).parent(null).dependencyManagement(dependencyManagement.withDependencies(dependencies)).build(null), (ModelBase)model);
            builder.packaging(POM_PACKAGING);
            builder.profiles((Collection)model.getProfiles().stream().map(p -> DefaultConsumerPomBuilder.prune(Profile.newBuilder((Profile)p, (boolean)true), (ModelBase)p).build()).collect(Collectors.toList()));
            model = builder.build();
            String modelVersion = new MavenModelVersion().getModelVersion(model);
            model = model.withModelVersion(modelVersion);
        } else {
            Model.Builder builder = DefaultConsumerPomBuilder.prune(Model.newBuilder((Model)model, (boolean)true).preserveModelVersion(false).root(false).parent(null).build(null), (ModelBase)model);
            builder.profiles((Collection)model.getProfiles().stream().map(p -> DefaultConsumerPomBuilder.prune(Profile.newBuilder((Profile)p, (boolean)true), (ModelBase)p).build()).collect(Collectors.toList()));
            model = builder.build();
            String modelVersion = new MavenModelVersion().getModelVersion(model);
            model = model.withModelVersion(modelVersion);
        }
        return model;
    }

    private static <T extends ModelBase.Builder> T prune(T builder, ModelBase model) {
        builder.properties(null).reporting(null);
        if (model.getDistributionManagement() != null && model.getDistributionManagement().getRelocation() != null) {
            builder.distributionManagement(DistributionManagement.newBuilder().relocation(model.getDistributionManagement().getRelocation()).build());
        }
        builder.pluginRepositories(DefaultConsumerPomBuilder.pruneRepositories(model.getPluginRepositories()));
        builder.repositories(DefaultConsumerPomBuilder.pruneRepositories(model.getRepositories()));
        return builder;
    }

    private static List<Repository> pruneRepositories(List<Repository> repositories) {
        return repositories.stream().filter(r -> !"central".equals(r.getId())).collect(Collectors.toList());
    }
}

