/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.ToolchainManager;
import org.apache.maven.api.services.ToolchainManagerException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.MappedList;
import org.apache.maven.toolchain.DefaultToolchainManagerPrivate;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainPrivate;

@Named
@Singleton
public class DefaultToolchainManager
implements ToolchainManager {
    private final DefaultToolchainManagerPrivate toolchainManagerPrivate;

    @Inject
    public DefaultToolchainManager(DefaultToolchainManagerPrivate toolchainManagerPrivate) {
        this.toolchainManagerPrivate = toolchainManagerPrivate;
    }

    public List<org.apache.maven.api.Toolchain> getToolchains(Session session, String type, Map<String, String> requirements) throws ToolchainManagerException {
        MavenSession s = InternalSession.from(session).getMavenSession();
        List<Toolchain> toolchains = this.toolchainManagerPrivate.getToolchains(s, type, requirements);
        return new MappedList<org.apache.maven.api.Toolchain, Toolchain>(toolchains, this::toToolchain);
    }

    public Optional<org.apache.maven.api.Toolchain> getToolchainFromBuildContext(Session session, String type) throws ToolchainManagerException {
        MavenSession s = InternalSession.from(session).getMavenSession();
        return Optional.ofNullable(this.toolchainManagerPrivate.getToolchainFromBuildContext(type, s)).map(this::toToolchain);
    }

    public List<org.apache.maven.api.Toolchain> getToolchainsForType(Session session, String type) throws ToolchainManagerException {
        try {
            MavenSession s = InternalSession.from(session).getMavenSession();
            ToolchainPrivate[] toolchains = this.toolchainManagerPrivate.getToolchainsForType(type, s);
            return new MappedList<org.apache.maven.api.Toolchain, ToolchainPrivate>(Arrays.asList(toolchains), this::toToolchain);
        }
        catch (MisconfiguredToolchainException e) {
            throw new ToolchainManagerException("Unable to get toochains for type " + type, (Exception)e);
        }
    }

    public void storeToolchainToBuildContext(Session session, org.apache.maven.api.Toolchain toolchain) throws ToolchainManagerException {
        MavenSession s = InternalSession.from(session).getMavenSession();
        ToolchainPrivate tc = (ToolchainPrivate)((ToolchainWrapper)toolchain).toolchain;
        this.toolchainManagerPrivate.storeToolchainToBuildContext(tc, s);
    }

    private org.apache.maven.api.Toolchain toToolchain(Toolchain toolchain) {
        return new ToolchainWrapper(toolchain);
    }

    private static class ToolchainWrapper
    implements org.apache.maven.api.Toolchain {
        private final Toolchain toolchain;

        ToolchainWrapper(Toolchain toolchain) {
            this.toolchain = toolchain;
        }

        public String getType() {
            return this.toolchain.getType();
        }

        public String findTool(String toolName) {
            return this.toolchain.findTool(toolName);
        }

        public boolean matchesRequirements(Map<String, String> requirements) {
            return ((ToolchainPrivate)this.toolchain).matchesRequirements(requirements);
        }
    }
}

