/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Session;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.SessionData;

@Singleton
@Named
public class DefaultSessionFactory {
    private final RepositorySystem repositorySystem;
    private final MavenRepositorySystem mavenRepositorySystem;
    private final PlexusContainer plexusContainer;
    private final RuntimeInformation runtimeInformation;

    @Inject
    public DefaultSessionFactory(RepositorySystem repositorySystem, MavenRepositorySystem mavenRepositorySystem, PlexusContainer plexusContainer, RuntimeInformation runtimeInformation) {
        this.repositorySystem = repositorySystem;
        this.mavenRepositorySystem = mavenRepositorySystem;
        this.plexusContainer = plexusContainer;
        this.runtimeInformation = runtimeInformation;
    }

    public Session getSession(MavenSession mavenSession) {
        SessionData data = mavenSession.getRepositorySession().getData();
        return (Session)data.computeIfAbsent(InternalSession.class, () -> this.newSession(mavenSession));
    }

    private Session newSession(MavenSession mavenSession) {
        return new DefaultSession(mavenSession, this.repositorySystem, null, this.mavenRepositorySystem, this.plexusContainer, this.runtimeInformation);
    }
}

