/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.LocalRepository;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Service;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.MavenException;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.internal.impl.AbstractSession;
import org.apache.maven.internal.impl.DefaultDependencyCoordinate;
import org.apache.maven.internal.impl.DefaultLocalRepository;
import org.apache.maven.internal.impl.DefaultProject;
import org.apache.maven.internal.impl.DefaultRemoteRepository;
import org.apache.maven.internal.impl.PropertiesAsMap;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.LocalRepositoryManager;

public class DefaultSession
extends AbstractSession {
    private final MavenSession mavenSession;
    private final RepositorySystemSession session;
    private final RepositorySystem repositorySystem;
    private final List<RemoteRepository> repositories;
    private final MavenRepositorySystem mavenRepositorySystem;
    private final PlexusContainer container;
    private final RuntimeInformation runtimeInformation;
    private final Map<Class<? extends Service>, Service> services = new ConcurrentHashMap<Class<? extends Service>, Service>();

    public DefaultSession(@Nonnull MavenSession session, @Nonnull RepositorySystem repositorySystem, @Nullable List<RemoteRepository> repositories, @Nonnull MavenRepositorySystem mavenRepositorySystem, @Nonnull PlexusContainer container, @Nonnull RuntimeInformation runtimeInformation) {
        this.mavenSession = Utils.nonNull(session);
        this.session = this.mavenSession.getRepositorySession();
        this.repositorySystem = Utils.nonNull(repositorySystem);
        this.repositories = repositories != null ? repositories : Utils.map(this.mavenSession.getRequest().getRemoteRepositories(), r -> this.getRemoteRepository(RepositoryUtils.toRepo(r)));
        this.mavenRepositorySystem = mavenRepositorySystem;
        this.container = container;
        this.runtimeInformation = runtimeInformation;
    }

    @Override
    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    @Nonnull
    public LocalRepository getLocalRepository() {
        return new DefaultLocalRepository(this.session.getLocalRepository());
    }

    @Nonnull
    public List<RemoteRepository> getRemoteRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    @Nonnull
    public Settings getSettings() {
        return this.mavenSession.getSettings().getDelegate();
    }

    @Nonnull
    public Map<String, String> getUserProperties() {
        return new PropertiesAsMap(this.mavenSession.getUserProperties());
    }

    @Nonnull
    public Map<String, String> getSystemProperties() {
        return new PropertiesAsMap(this.mavenSession.getSystemProperties());
    }

    @Nonnull
    public String getMavenVersion() {
        return this.runtimeInformation.getMavenVersion();
    }

    public int getDegreeOfConcurrency() {
        return this.mavenSession.getRequest().getDegreeOfConcurrency();
    }

    @Nonnull
    public Instant getStartTime() {
        return this.mavenSession.getStartTime().toInstant();
    }

    public Path getRootDirectory() {
        return this.mavenSession.getRequest().getRootDirectory();
    }

    public Path getTopDirectory() {
        return this.mavenSession.getRequest().getTopDirectory();
    }

    @Nonnull
    public List<Project> getProjects() {
        return this.getProjects(this.mavenSession.getProjects());
    }

    @Nonnull
    public Map<String, Object> getPluginContext(Project project) {
        Utils.nonNull(project, "project");
        try {
            MojoExecution mojoExecution = (MojoExecution)this.container.lookup(MojoExecution.class);
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
            return this.mavenSession.getPluginContext(pluginDescriptor, ((DefaultProject)project).getProject());
        }
        catch (ComponentLookupException e) {
            throw new MavenException("The PluginContext is only available during a mojo execution", (Throwable)e);
        }
    }

    @Nonnull
    public org.apache.maven.api.SessionData getData() {
        final SessionData data = this.session.getData();
        return new org.apache.maven.api.SessionData(){

            public void set(@Nonnull Object key, @Nullable Object value) {
                data.set(key, value);
            }

            public boolean set(@Nonnull Object key, @Nullable Object oldValue, @Nullable Object newValue) {
                return data.set(key, oldValue, newValue);
            }

            @Nullable
            public Object get(@Nonnull Object key) {
                return data.get(key);
            }

            @Nullable
            public Object computeIfAbsent(@Nonnull Object key, @Nonnull Supplier<Object> supplier) {
                return data.computeIfAbsent(key, supplier);
            }
        };
    }

    @Nonnull
    public Session withLocalRepository(@Nonnull LocalRepository localRepository) {
        Utils.nonNull(localRepository, "localRepository");
        if (this.session.getLocalRepository() != null && Objects.equals(this.session.getLocalRepository().getBasedir().toPath(), localRepository.getPath())) {
            return this;
        }
        org.eclipse.aether.repository.LocalRepository repository = this.toRepository(localRepository);
        LocalRepositoryManager localRepositoryManager = this.repositorySystem.newLocalRepositoryManager(this.session, repository);
        DefaultRepositorySystemSession repoSession = new DefaultRepositorySystemSession(this.session).setLocalRepositoryManager(localRepositoryManager);
        MavenSession newSession = new MavenSession((RepositorySystemSession)repoSession, this.mavenSession.getRequest(), this.mavenSession.getResult());
        return new DefaultSession(newSession, this.repositorySystem, this.repositories, this.mavenRepositorySystem, this.container, this.runtimeInformation);
    }

    @Nonnull
    public Session withRemoteRepositories(@Nonnull List<RemoteRepository> repositories) {
        return new DefaultSession(this.mavenSession, this.repositorySystem, repositories, this.mavenRepositorySystem, this.container, this.runtimeInformation);
    }

    @Nonnull
    public <T extends Service> T getService(Class<T> clazz) throws NoSuchElementException {
        Service t = this.services.computeIfAbsent(clazz, this::lookup);
        if (t == null) {
            throw new NoSuchElementException(clazz.getName());
        }
        return (T)t;
    }

    private Service lookup(Class<? extends Service> c) {
        try {
            return (Service)this.container.lookup(c);
        }
        catch (ComponentLookupException e) {
            NoSuchElementException nsee = new NoSuchElementException(c.getName());
            e.initCause((Throwable)e);
            throw nsee;
        }
    }

    @Override
    @Nonnull
    public RepositorySystemSession getSession() {
        return this.session;
    }

    @Override
    @Nonnull
    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    @Override
    public ArtifactRepository toArtifactRepository(RemoteRepository repository) {
        if (repository instanceof DefaultRemoteRepository) {
            org.eclipse.aether.repository.RemoteRepository rr = ((DefaultRemoteRepository)repository).getRepository();
            try {
                return this.mavenRepositorySystem.createRepository(rr.getUrl(), rr.getId(), rr.getPolicy(false).isEnabled(), rr.getPolicy(false).getUpdatePolicy(), rr.getPolicy(true).isEnabled(), rr.getPolicy(true).getUpdatePolicy(), rr.getPolicy(false).getChecksumPolicy());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create repository", e);
            }
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Dependency toDependency(DependencyCoordinate dependency) {
        if (dependency instanceof DefaultDependencyCoordinate) {
            return ((DefaultDependencyCoordinate)dependency).getDependency();
        }
        return new Dependency((Artifact)new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType().getExtension(), dependency.getVersion().toString(), null), dependency.getScope().id());
    }
}

