/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.Node;
import org.apache.maven.api.Project;
import org.apache.maven.api.ResolutionScope;
import org.apache.maven.api.Scope;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.DependencyCollector;
import org.apache.maven.api.services.DependencyCollectorException;
import org.apache.maven.api.services.DependencyCollectorRequest;
import org.apache.maven.api.services.DependencyCollectorResult;
import org.apache.maven.api.services.DependencyResolver;
import org.apache.maven.api.services.DependencyResolverException;
import org.apache.maven.api.services.DependencyResolverRequest;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.internal.impl.AbstractNode;
import org.apache.maven.internal.impl.DefaultProject;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.internal.LifecycleDependencyResolver;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.PreorderDependencyNodeConsumerVisitor;

@Named
@Singleton
public class DefaultDependencyResolver
implements DependencyResolver {
    @Inject
    public DefaultDependencyResolver() {
    }

    public List<Node> flatten(Session s, Node node, ResolutionScope scope) throws DependencyResolverException {
        InternalSession session = InternalSession.from(s);
        DependencyNode root = Utils.cast(AbstractNode.class, node, "node").getDependencyNode();
        ArrayList dependencies = new ArrayList();
        PreorderDependencyNodeConsumerVisitor builder = new PreorderDependencyNodeConsumerVisitor(dependencies::add);
        DependencyFilter filter = DefaultDependencyResolver.getScopeDependencyFilter(scope);
        FilteringDependencyVisitor visitor = new FilteringDependencyVisitor((DependencyVisitor)builder, filter);
        root.accept((DependencyVisitor)visitor);
        dependencies.remove(root);
        return Utils.map(dependencies, session::getNode);
    }

    private static DependencyFilter getScopeDependencyFilter(ResolutionScope scope) {
        Set scopes = scope.scopes().stream().map(Scope::id).collect(Collectors.toSet());
        return (n, p) -> {
            Dependency d = n.getDependency();
            return d == null || scopes.contains(d.getScope());
        };
    }

    public DependencyResolverResult resolve(DependencyResolverRequest request) throws DependencyCollectorException, DependencyResolverException, ArtifactResolverException {
        Utils.nonNull(request, "request can not be null");
        InternalSession session = InternalSession.from(request.getSession());
        if (request.getProject().isPresent()) {
            List<org.apache.maven.api.Artifact> artifacts = this.resolveDependencies(request.getSession(), (Project)request.getProject().get(), request.getResolutionScope());
            List<Path> paths = artifacts.stream().map(a -> (Path)((ArtifactManager)request.getSession().getService(ArtifactManager.class)).getPath(a).get()).collect(Collectors.toList());
            return new DefaultDependencyResolverResult(Collections.emptyList(), null, Collections.emptyList(), paths);
        }
        DependencyCollectorResult collectorResult = ((DependencyCollector)session.getService(DependencyCollector.class)).collect((DependencyCollectorRequest)request);
        List<Node> dependencies = this.flatten(session, collectorResult.getRoot(), request.getResolutionScope());
        List coordinates = dependencies.stream().map(Node::getDependency).filter(Objects::nonNull).map(org.apache.maven.api.Artifact::toCoordinate).collect(Collectors.toList());
        Map artifacts = session.resolveArtifacts(coordinates);
        List<Path> paths = dependencies.stream().map(Node::getDependency).filter(Objects::nonNull).map(artifacts::get).filter(Objects::nonNull).collect(Collectors.toList());
        return new DefaultDependencyResolverResult(collectorResult.getExceptions(), collectorResult.getRoot(), dependencies, paths);
    }

    private List<org.apache.maven.api.Artifact> resolveDependencies(Session session, Project project, ResolutionScope scope) {
        Collection<String> toResolve = this.toScopes(scope);
        try {
            LifecycleDependencyResolver lifecycleDependencyResolver = (LifecycleDependencyResolver)((Lookup)session.getService(Lookup.class)).lookup(LifecycleDependencyResolver.class);
            Set<Artifact> artifacts = lifecycleDependencyResolver.resolveProjectArtifacts(this.getMavenProject(project), toResolve, toResolve, InternalSession.from(session).getMavenSession(), false, Collections.emptySet());
            return Utils.map(artifacts, a -> InternalSession.from(session).getArtifact(RepositoryUtils.toArtifact(a)));
        }
        catch (LifecycleExecutionException e) {
            throw new DependencyResolverException("Unable to resolve project dependencies", (Throwable)e);
        }
    }

    private MavenProject getMavenProject(Project project) {
        return ((DefaultProject)project).getProject();
    }

    private Collection<String> toScopes(ResolutionScope scope) {
        return Utils.map(scope.scopes(), Scope::id);
    }

    static class DefaultDependencyResolverResult
    implements DependencyResolverResult {
        private final List<Exception> exceptions;
        private final Node root;
        private final List<Node> dependencies;
        private final List<Path> paths;

        DefaultDependencyResolverResult(List<Exception> exceptions, Node root, List<Node> dependencies, List<Path> paths) {
            this.exceptions = exceptions;
            this.root = root;
            this.dependencies = dependencies;
            this.paths = paths;
        }

        public List<Exception> getExceptions() {
            return this.exceptions;
        }

        public Node getRoot() {
            return this.root;
        }

        public List<Node> getDependencies() {
            return this.dependencies;
        }

        public List<Path> getPaths() {
            return this.paths;
        }
    }
}

