/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Node;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.DependencyCollector;
import org.apache.maven.api.services.DependencyCollectorException;
import org.apache.maven.api.services.DependencyCollectorRequest;
import org.apache.maven.api.services.DependencyCollectorResult;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;

@Named
@Singleton
public class DefaultDependencyCollector
implements DependencyCollector {
    private final RepositorySystem repositorySystem;

    @Inject
    DefaultDependencyCollector(@Nonnull RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    @Nonnull
    public DependencyCollectorResult collect(final @Nonnull DependencyCollectorRequest request) throws DependencyCollectorException, IllegalArgumentException {
        Utils.nonNull(request, "request");
        final InternalSession session = InternalSession.from(request.getSession());
        Artifact rootArtifact = request.getRootArtifact().map(session::toArtifact).orElse(null);
        Dependency root = request.getRoot().map(session::toDependency).orElse(null);
        CollectRequest collectRequest = new CollectRequest().setRootArtifact(rootArtifact).setRoot(root).setDependencies(session.toDependencies(request.getDependencies())).setManagedDependencies(session.toDependencies(request.getManagedDependencies())).setRepositories(session.toRepositories(session.getRemoteRepositories()));
        RepositorySystemSession systemSession = session.getSession();
        if (request.getVerbose()) {
            systemSession = new DefaultRepositorySystemSession(systemSession).setConfigProperty("aether.conflictResolver.verbose", (Object)true).setConfigProperty("aether.dependencyManager.verbose", (Object)true);
        }
        try {
            final CollectResult result = this.repositorySystem.collectDependencies(systemSession, collectRequest);
            return new DependencyCollectorResult(){

                public List<Exception> getExceptions() {
                    return result.getExceptions();
                }

                public Node getRoot() {
                    return session.getNode(result.getRoot(), request.getVerbose());
                }
            };
        }
        catch (DependencyCollectionException e) {
            throw new DependencyCollectorException("Unable to collect dependencies", (Throwable)e);
        }
    }
}

