/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Objects;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.DependencyProperties;
import org.apache.maven.api.Scope;
import org.apache.maven.api.Type;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.internal.impl.DefaultDependencyProperties;
import org.apache.maven.internal.impl.DefaultVersionParser;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.graph.Dependency;

public class DefaultDependency
implements org.apache.maven.api.Dependency {
    private final InternalSession session;
    private final Dependency dependency;
    private final DependencyProperties dependencyProperties;
    private final String key;

    public DefaultDependency(@Nonnull InternalSession session, @Nonnull Dependency dependency) {
        this.session = Utils.nonNull(session, "session");
        this.dependency = Utils.nonNull(dependency, "dependency");
        this.dependencyProperties = new DefaultDependencyProperties(dependency.getArtifact().getProperties());
        this.key = this.getGroupId() + ':' + this.getArtifactId() + ':' + this.getExtension() + (!this.getClassifier().isEmpty() ? ":" + this.getClassifier() : "") + ':' + this.getVersion();
    }

    public String key() {
        return this.key;
    }

    @Nonnull
    public Dependency getDependency() {
        return this.dependency;
    }

    public String getGroupId() {
        return this.dependency.getArtifact().getGroupId();
    }

    public String getArtifactId() {
        return this.dependency.getArtifact().getArtifactId();
    }

    public String getClassifier() {
        return this.dependency.getArtifact().getClassifier();
    }

    public Version getVersion() {
        return this.session.parseVersion(this.dependency.getArtifact().getVersion());
    }

    public String getExtension() {
        return this.dependency.getArtifact().getExtension();
    }

    public Type getType() {
        String type = this.dependency.getArtifact().getProperty("type", this.dependency.getArtifact().getExtension());
        return ((TypeRegistry)this.session.getService(TypeRegistry.class)).getType(type);
    }

    public DependencyProperties getDependencyProperties() {
        return this.dependencyProperties;
    }

    public boolean isSnapshot() {
        return DefaultVersionParser.checkSnapshot(this.dependency.getArtifact().getVersion());
    }

    @Nonnull
    public Scope getScope() {
        return Scope.get((String)this.dependency.getScope());
    }

    @Nullable
    public boolean isOptional() {
        return this.dependency.isOptional();
    }

    @Nonnull
    public DependencyCoordinate toCoordinate() {
        return this.session.createDependencyCoordinate(this);
    }

    public boolean equals(Object o) {
        return o instanceof Artifact && Objects.equals(this.key(), ((Artifact)o).key());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.dependency.toString();
    }
}

