/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ArtifactResolver;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.ArtifactResolverRequest;
import org.apache.maven.api.services.ArtifactResolverResult;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Named
@Singleton
public class DefaultArtifactResolver
implements ArtifactResolver {
    private final RepositorySystem repositorySystem;

    @Inject
    DefaultArtifactResolver(@Nonnull RepositorySystem repositorySystem) {
        this.repositorySystem = Utils.nonNull(repositorySystem, "repositorySystem");
    }

    public ArtifactResolverResult resolve(ArtifactResolverRequest request) throws ArtifactResolverException, IllegalArgumentException {
        Utils.nonNull(request, "request");
        InternalSession session = InternalSession.from(request.getSession());
        try {
            Path path;
            org.apache.maven.api.Artifact artifact;
            HashMap<org.apache.maven.api.Artifact, Path> paths = new HashMap<org.apache.maven.api.Artifact, Path>();
            ArtifactManager artifactManager = (ArtifactManager)session.getService(ArtifactManager.class);
            List<RemoteRepository> repositories = session.toRepositories(session.getRemoteRepositories());
            ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();
            for (ArtifactCoordinate coord : request.getCoordinates()) {
                Artifact aetherArtifact = session.toArtifact(coord);
                artifact = session.getArtifact(aetherArtifact);
                path = artifactManager.getPath(artifact).orElse(null);
                if (path != null) {
                    paths.put(artifact, path);
                    continue;
                }
                requests.add(new ArtifactRequest(aetherArtifact, repositories, null));
            }
            if (!requests.isEmpty()) {
                List results = this.repositorySystem.resolveArtifacts(session.getSession(), requests);
                for (ArtifactResult result : results) {
                    artifact = session.getArtifact(result.getArtifact());
                    path = result.getArtifact().getFile().toPath();
                    artifactManager.setPath(artifact, path);
                    paths.put(artifact, path);
                }
            }
            return () -> paths;
        }
        catch (ArtifactResolutionException e) {
            throw new ArtifactResolverException("Unable to resolve artifact", (Exception)((Object)e));
        }
    }
}

