/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Objects;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.internal.impl.DefaultVersionParser;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.artifact.Artifact;

public class DefaultArtifact
implements org.apache.maven.api.Artifact {
    @Nonnull
    private final InternalSession session;
    @Nonnull
    private final Artifact artifact;
    private final String key;

    public DefaultArtifact(@Nonnull InternalSession session, @Nonnull Artifact artifact) {
        this.session = Utils.nonNull(session, "session");
        this.artifact = Utils.nonNull(artifact, "artifact");
        this.key = this.getGroupId() + ':' + this.getArtifactId() + ':' + this.getExtension() + (this.getClassifier().isEmpty() ? "" : ":" + this.getClassifier()) + ':' + this.getVersion();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String key() {
        return this.key;
    }

    @Nonnull
    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    @Nonnull
    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    @Nonnull
    public Version getVersion() {
        return this.session.parseVersion(this.artifact.getVersion());
    }

    @Nonnull
    public String getExtension() {
        return this.artifact.getExtension();
    }

    @Nonnull
    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    public boolean isSnapshot() {
        return DefaultVersionParser.checkSnapshot(this.artifact.getVersion());
    }

    @Nonnull
    public ArtifactCoordinate toCoordinate() {
        return this.session.createArtifactCoordinate(this);
    }

    public boolean equals(Object o) {
        return o instanceof org.apache.maven.api.Artifact && Objects.equals(this.key(), ((org.apache.maven.api.Artifact)o).key());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.artifact.toString();
    }
}

