/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.internal.aether.LoggingRepositoryListener;
import org.apache.maven.internal.aether.ReverseTreeRepositoryListener;
import org.apache.maven.internal.aether.TypeRegistryAdapter;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.apache.maven.internal.xml.XmlPlexusConfiguration;
import org.apache.maven.model.ModelBase;
import org.apache.maven.repository.Proxy;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.util.listener.ChainedRepositoryListener;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.eclipse.sisu.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultRepositorySystemSessionFactory {
    private static final String MAVEN_REPO_LOCAL_TAIL = "maven.repo.local.tail";
    private static final String MAVEN_REPO_LOCAL_RECORD_REVERSE_TREE = "maven.repo.local.recordReverseTree";
    private static final String MAVEN_RESOLVER_TRANSPORT_KEY = "maven.resolver.transport";
    private static final String MAVEN_RESOLVER_TRANSPORT_DEFAULT = "default";
    private static final String MAVEN_RESOLVER_TRANSPORT_WAGON = "wagon";
    private static final String MAVEN_RESOLVER_TRANSPORT_APACHE = "apache";
    private static final String MAVEN_RESOLVER_TRANSPORT_JDK = "jdk";
    @Deprecated
    private static final String MAVEN_RESOLVER_TRANSPORT_NATIVE = "native";
    private static final String MAVEN_RESOLVER_TRANSPORT_AUTO = "auto";
    private static final String WAGON_TRANSPORTER_PRIORITY_KEY = "aether.priority.WagonTransporterFactory";
    private static final String APACHE_HTTP_TRANSPORTER_PRIORITY_KEY = "aether.priority.ApacheTransporterFactory";
    private static final String JDK_HTTP_TRANSPORTER_PRIORITY_KEY = "aether.priority.JdkTransporterFactory";
    private static final String FILE_TRANSPORTER_PRIORITY_KEY = "aether.priority.FileTransporterFactory";
    private static final String RESOLVER_MAX_PRIORITY = String.valueOf(Float.MAX_VALUE);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ArtifactHandlerManager artifactHandlerManager;
    private final RepositorySystem repoSystem;
    private final WorkspaceReader workspaceRepository;
    private final SettingsDecrypter settingsDecrypter;
    private final EventSpyDispatcher eventSpyDispatcher;
    private final RuntimeInformation runtimeInformation;
    private final TypeRegistry typeRegistry;

    @Inject
    public DefaultRepositorySystemSessionFactory(ArtifactHandlerManager artifactHandlerManager, RepositorySystem repoSystem, @Nullable @Named(value="ide") WorkspaceReader workspaceRepository, SettingsDecrypter settingsDecrypter, EventSpyDispatcher eventSpyDispatcher, RuntimeInformation runtimeInformation, TypeRegistry typeRegistry) {
        this.artifactHandlerManager = artifactHandlerManager;
        this.repoSystem = repoSystem;
        this.workspaceRepository = workspaceRepository;
        this.settingsDecrypter = settingsDecrypter;
        this.eventSpyDispatcher = eventSpyDispatcher;
        this.runtimeInformation = runtimeInformation;
        this.typeRegistry = typeRegistry;
    }

    @Deprecated
    public RepositorySystemSession newRepositorySession(MavenExecutionRequest request) {
        return this.newRepositorySessionBuilder(request).build();
    }

    public RepositorySystemSession.SessionBuilder newRepositorySessionBuilder(MavenExecutionRequest request) {
        boolean recordReverseTree;
        RepositorySystemSession.SessionBuilder session = MavenRepositorySystemUtils.newSession((RepositorySystemSession.SessionBuilder)this.repoSystem.createSessionBuilder(), (ArtifactTypeRegistry)new TypeRegistryAdapter(this.typeRegistry));
        session.setCache(request.getRepositoryCache());
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>();
        configProps.put("aether.transport.http.userAgent", this.getUserAgent());
        configProps.put("aether.interactive", request.isInteractiveMode());
        configProps.put("maven.startTime", request.getStartTime());
        configProps.putAll(this.getPropertiesFromRequestedProfiles(request));
        configProps.putAll(request.getSystemProperties());
        configProps.putAll(request.getUserProperties());
        session.setOffline(request.isOffline());
        session.setChecksumPolicy(request.getGlobalChecksumPolicy());
        session.setUpdatePolicy(request.isNoSnapshotUpdates() ? "never" : (request.isUpdateSnapshots() ? "always" : null));
        int errorPolicy = 0;
        errorPolicy |= request.isCacheNotFound() ? 1 : 0;
        session.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(errorPolicy |= request.isCacheTransferError() ? 2 : 0, errorPolicy | 1));
        session.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(request.isIgnoreMissingArtifactDescriptor(), request.isIgnoreInvalidArtifactDescriptor()));
        session.setArtifactTypeRegistry(RepositoryUtils.newArtifactTypeRegistry(this.artifactHandlerManager));
        session.setWorkspaceReader(request.getWorkspaceReader() != null ? request.getWorkspaceReader() : this.workspaceRepository);
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies(request.getProxies());
        decrypt.setServers(request.getServers());
        SettingsDecryptionResult decrypted = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)decrypt);
        if (this.logger.isDebugEnabled()) {
            for (SettingsProblem problem : decrypted.getProblems()) {
                this.logger.debug(problem.getMessage(), (Throwable)problem.getException());
            }
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : request.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.isBlocked(), mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        session.setMirrorSelector((MirrorSelector)mirrorSelector);
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (Object proxy : decrypted.getProxies()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(proxy.getUsername()).addPassword(proxy.getPassword());
            proxySelector.add(new org.eclipse.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authBuilder.build()), proxy.getNonProxyHosts());
        }
        session.setProxySelector((ProxySelector)proxySelector);
        DefaultAuthenticationSelector defaultAuthenticationSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            defaultAuthenticationSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                PlexusConfiguration connectTimeoutXml;
                PlexusConfiguration[] properties;
                XmlNode dom = server.getDelegate().getConfiguration();
                List children = dom.getChildren().stream().filter(c -> !"wagonProvider".equals(c.getName())).collect(Collectors.toList());
                dom = new XmlNodeImpl(dom.getName(), null, null, children, null);
                PlexusConfiguration config = XmlPlexusConfiguration.toPlexusConfiguration((XmlNode)dom);
                configProps.put("aether.transport.wagon.config." + server.getId(), config);
                HashMap<String, String> headers = null;
                Integer connectTimeout = null;
                Integer requestTimeout = null;
                PlexusConfiguration httpHeaders = config.getChild("httpHeaders", false);
                if (httpHeaders != null && (properties = httpHeaders.getChildren("property")) != null && properties.length > 0) {
                    headers = new HashMap<String, String>();
                    for (PlexusConfiguration property : properties) {
                        headers.put(property.getChild("name").getValue(), property.getChild("value").getValue());
                    }
                }
                if ((connectTimeoutXml = config.getChild("connectTimeout", false)) != null) {
                    connectTimeout = Integer.parseInt(connectTimeoutXml.getValue());
                } else {
                    PlexusConfiguration httpConfigurationAll;
                    PlexusConfiguration httpConfiguration = config.getChild("httpConfiguration", false);
                    if (httpConfiguration != null && (httpConfigurationAll = httpConfiguration.getChild("all", false)) != null && (connectTimeoutXml = httpConfigurationAll.getChild("connectionTimeout", false)) != null) {
                        connectTimeout = Integer.parseInt(connectTimeoutXml.getValue());
                        this.logger.warn("Settings for server {} uses legacy format", (Object)server.getId());
                    }
                }
                PlexusConfiguration requestTimeoutXml = config.getChild("requestTimeout", false);
                if (requestTimeoutXml != null) {
                    requestTimeout = Integer.parseInt(requestTimeoutXml.getValue());
                } else {
                    PlexusConfiguration httpConfigurationAll;
                    PlexusConfiguration httpConfiguration = config.getChild("httpConfiguration", false);
                    if (httpConfiguration != null && (httpConfigurationAll = httpConfiguration.getChild("all", false)) != null && (requestTimeoutXml = httpConfigurationAll.getChild("readTimeout", false)) != null) {
                        requestTimeout = Integer.parseInt(requestTimeoutXml.getValue());
                        this.logger.warn("Settings for server {} uses legacy format", (Object)server.getId());
                    }
                }
                if (headers != null) {
                    configProps.put("aether.transport.http.headers." + server.getId(), headers);
                }
                if (connectTimeout != null) {
                    configProps.put("aether.transport.http.connectTimeout." + server.getId(), connectTimeout);
                }
                if (requestTimeout != null) {
                    configProps.put("aether.transport.http.requestTimeout." + server.getId(), requestTimeout);
                }
            }
            configProps.put("aether.transport.wagon.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.transport.wagon.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector((AuthenticationSelector)defaultAuthenticationSelector);
        String transport = configProps.getOrDefault(MAVEN_RESOLVER_TRANSPORT_KEY, MAVEN_RESOLVER_TRANSPORT_DEFAULT);
        if (!MAVEN_RESOLVER_TRANSPORT_DEFAULT.equals(transport)) {
            if (MAVEN_RESOLVER_TRANSPORT_JDK.equals(transport)) {
                configProps.put(FILE_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
                configProps.put(JDK_HTTP_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
            } else if (MAVEN_RESOLVER_TRANSPORT_APACHE.equals(transport) || MAVEN_RESOLVER_TRANSPORT_NATIVE.equals(transport)) {
                if (MAVEN_RESOLVER_TRANSPORT_NATIVE.equals(transport)) {
                    this.logger.warn("Transport name '{}' is DEPRECATED/RENAMED, use '{}' instead", (Object)MAVEN_RESOLVER_TRANSPORT_NATIVE, (Object)MAVEN_RESOLVER_TRANSPORT_APACHE);
                }
                configProps.put(FILE_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
                configProps.put(APACHE_HTTP_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
            } else if (MAVEN_RESOLVER_TRANSPORT_WAGON.equals(transport)) {
                configProps.put(WAGON_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
            } else if (!MAVEN_RESOLVER_TRANSPORT_AUTO.equals(transport)) {
                throw new IllegalArgumentException("Unknown resolver transport '" + transport + "'. Supported transports are: " + MAVEN_RESOLVER_TRANSPORT_WAGON + ", " + MAVEN_RESOLVER_TRANSPORT_APACHE + ", " + MAVEN_RESOLVER_TRANSPORT_JDK + ", " + MAVEN_RESOLVER_TRANSPORT_AUTO);
            }
        }
        session.setUserProperties((Map)request.getUserProperties());
        session.setSystemProperties((Map)request.getSystemProperties());
        session.setConfigProperties(configProps);
        session.setTransferListener(request.getTransferListener());
        RepositoryListener repositoryListener = this.eventSpyDispatcher.chainListener((RepositoryListener)new LoggingRepositoryListener(this.logger));
        boolean bl = recordReverseTree = configProps.containsKey(MAVEN_REPO_LOCAL_RECORD_REVERSE_TREE) && Boolean.parseBoolean((String)configProps.get(MAVEN_REPO_LOCAL_RECORD_REVERSE_TREE));
        if (recordReverseTree) {
            repositoryListener = new ChainedRepositoryListener(new RepositoryListener[]{repositoryListener, new ReverseTreeRepositoryListener()});
        }
        session.setRepositoryListener(repositoryListener);
        this.injectMirror(request.getRemoteRepositories(), request.getMirrors());
        this.injectProxy((ProxySelector)proxySelector, request.getRemoteRepositories());
        this.injectAuthentication((AuthenticationSelector)defaultAuthenticationSelector, request.getRemoteRepositories());
        this.injectMirror(request.getPluginArtifactRepositories(), request.getMirrors());
        this.injectProxy((ProxySelector)proxySelector, request.getPluginArtifactRepositories());
        this.injectAuthentication((AuthenticationSelector)defaultAuthenticationSelector, request.getPluginArtifactRepositories());
        ArrayList<File> paths = new ArrayList<File>();
        paths.add(new File(request.getLocalRepository().getBasedir()));
        String localRepoTail = (String)configProps.get(MAVEN_REPO_LOCAL_TAIL);
        if (localRepoTail != null) {
            Arrays.stream(localRepoTail.split(",")).filter(p -> p != null && !p.trim().isEmpty()).map(File::new).forEach(paths::add);
        }
        session.withLocalRepositoryBaseDirectories(paths);
        return session;
    }

    private Map<?, ?> getPropertiesFromRequestedProfiles(MavenExecutionRequest request) {
        HashSet<String> activeProfileId = new HashSet<String>(request.getProfileActivation().getRequiredActiveProfileIds());
        activeProfileId.addAll(request.getProfileActivation().getOptionalActiveProfileIds());
        return request.getProfiles().stream().filter(profile -> activeProfileId.contains(profile.getId())).map(ModelBase::getProperties).flatMap(properties -> properties.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> k2));
    }

    private String getUserAgent() {
        String version = this.runtimeInformation.getMavenVersion();
        version = version.isEmpty() ? version : "/" + version;
        return "Apache-Maven" + version + " (Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ")";
    }

    private void injectMirror(List<ArtifactRepository> repositories, List<Mirror> mirrors) {
        if (repositories != null && mirrors != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = MavenRepositorySystem.getMirror(repository, mirrors);
                this.injectMirror(repository, mirror);
            }
        }
    }

    private void injectMirror(ArtifactRepository repository, Mirror mirror) {
        if (mirror != null) {
            ArtifactRepository original = MavenRepositorySystem.createArtifactRepository(repository.getId(), repository.getUrl(), repository.getLayout(), repository.getSnapshots(), repository.getReleases());
            repository.setMirroredRepositories(Collections.singletonList(original));
            repository.setId(mirror.getId());
            repository.setUrl(mirror.getUrl());
            if (mirror.getLayout() != null && !mirror.getLayout().isEmpty()) {
                repository.setLayout(original.getLayout());
            }
            repository.setBlocked(mirror.isBlocked());
        }
    }

    private void injectProxy(ProxySelector selector, List<ArtifactRepository> repositories) {
        if (repositories != null && selector != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setProxy(this.getProxy(selector, repository));
            }
        }
    }

    private Proxy getProxy(ProxySelector selector, ArtifactRepository repository) {
        RemoteRepository repo;
        org.eclipse.aether.repository.Proxy proxy;
        if (selector != null && (proxy = selector.getProxy(repo = RepositoryUtils.toRepo(repository))) != null) {
            Proxy p = new Proxy();
            p.setHost(proxy.getHost());
            p.setProtocol(proxy.getType());
            p.setPort(proxy.getPort());
            if (proxy.getAuthentication() != null) {
                repo = new RemoteRepository.Builder(repo).setProxy(proxy).build();
                AuthenticationContext authCtx = AuthenticationContext.forProxy(null, (RemoteRepository)repo);
                p.setUserName(authCtx.get("username"));
                p.setPassword(authCtx.get("password"));
                p.setNtlmDomain(authCtx.get("ntlm.domain"));
                p.setNtlmHost(authCtx.get("ntlm.workstation"));
                authCtx.close();
            }
            return p;
        }
        return null;
    }

    public void injectAuthentication(AuthenticationSelector selector, List<ArtifactRepository> repositories) {
        if (repositories != null && selector != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setAuthentication(this.getAuthentication(selector, repository));
            }
        }
    }

    private org.apache.maven.artifact.repository.Authentication getAuthentication(AuthenticationSelector selector, ArtifactRepository repository) {
        RemoteRepository repo;
        Authentication auth;
        if (selector != null && (auth = selector.getAuthentication(repo = RepositoryUtils.toRepo(repository))) != null) {
            repo = new RemoteRepository.Builder(repo).setAuthentication(auth).build();
            AuthenticationContext authCtx = AuthenticationContext.forRepository(null, (RemoteRepository)repo);
            org.apache.maven.artifact.repository.Authentication result = new org.apache.maven.artifact.repository.Authentication(authCtx.get("username"), authCtx.get("password"));
            result.setPrivateKey(authCtx.get("privateKey.path"));
            result.setPassphrase(authCtx.get("privateKey.passphrase"));
            authCtx.close();
            return result;
        }
        return null;
    }
}

