/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.transfer;

import java.io.PrintStream;
import java.util.Locale;
import org.apache.maven.cli.jansi.MessageUtils;
import org.apache.maven.cli.transfer.FileSizeFormat;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

public abstract class AbstractMavenTransferListener
extends AbstractTransferListener {
    private static final String ESC = "\u001b";
    private static final String ANSI_DARK_SET = "\u001b[90m";
    private static final String ANSI_DARK_RESET = "\u001b[0m";
    protected PrintStream out;

    protected AbstractMavenTransferListener(PrintStream out) {
        this.out = out;
    }

    public void transferInitiated(TransferEvent event) {
        String darkOn = MessageUtils.isColorEnabled() ? ANSI_DARK_SET : "";
        String darkOff = MessageUtils.isColorEnabled() ? ANSI_DARK_RESET : "";
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "to" : "from";
        TransferResource resource = event.getResource();
        StringBuilder message = new StringBuilder();
        message.append(darkOn).append(action).append(' ').append(direction).append(' ');
        message.append(darkOff).append(resource.getRepositoryId());
        message.append(darkOn).append(": ").append(resource.getRepositoryUrl());
        message.append(darkOff).append(resource.getResourceName());
        this.out.println(message.toString());
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.out.println("[WARNING] " + event.getException().getMessage() + " from " + resource.getRepositoryId() + " for " + resource.getRepositoryUrl() + resource.getResourceName());
    }

    public void transferSucceeded(TransferEvent event) {
        String darkOn = MessageUtils.isColorEnabled() ? ANSI_DARK_SET : "";
        String darkOff = MessageUtils.isColorEnabled() ? ANSI_DARK_RESET : "";
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "to" : "from";
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        FileSizeFormat format = new FileSizeFormat(Locale.ENGLISH);
        StringBuilder message = new StringBuilder();
        message.append(action).append(darkOn).append(' ').append(direction).append(' ');
        message.append(darkOff).append(resource.getRepositoryId());
        message.append(darkOn).append(": ").append(resource.getRepositoryUrl());
        message.append(darkOff).append(resource.getResourceName());
        message.append(darkOn).append(" (");
        format.format(message, contentLength);
        long duration = System.currentTimeMillis() - resource.getTransferStartTime();
        if (duration > 0L) {
            double bytesPerSecond = (double)contentLength / ((double)duration / 1000.0);
            message.append(" at ");
            format.format(message, (long)bytesPerSecond);
            message.append("/s");
        }
        message.append(')').append(darkOff);
        this.out.println(message.toString());
    }
}

