/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.descriptor.DuplicateParameterException;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;

public class MojoDescriptor
extends ComponentDescriptor<Mojo>
implements Cloneable {
    public static final String MAVEN_PLUGIN = "maven-plugin";
    public static final String SINGLE_PASS_EXEC_STRATEGY = "once-per-session";
    public static final String MULTI_PASS_EXEC_STRATEGY = "always";
    private static final String DEFAULT_INSTANTIATION_STRATEGY = "per-lookup";
    private static final String DEFAULT_LANGUAGE = "java";
    private final ArrayList<Parameter> parameters = new ArrayList();
    private String executionStrategy = "once-per-session";
    private String goal;
    private String phase;
    private String since;
    private String executePhase;
    private String executeGoal;
    private String executeLifecycle;
    private String deprecated;
    private boolean aggregator = false;
    private String dependencyResolutionRequired = null;
    private String dependencyCollectionRequired;
    private boolean projectRequired = true;
    private boolean onlineRequired = false;
    private PlexusConfiguration mojoConfiguration;
    private PluginDescriptor pluginDescriptor;
    private boolean inheritedByDefault = true;
    private boolean directInvocationOnly = false;
    private boolean requiresReports = false;
    private boolean threadSafe = false;
    private boolean v4Api = false;
    private volatile org.apache.maven.api.plugin.descriptor.MojoDescriptor mojoDescriptorV4;

    public MojoDescriptor() {
        this.setInstantiationStrategy(DEFAULT_INSTANTIATION_STRATEGY);
        this.setComponentFactory(DEFAULT_LANGUAGE);
    }

    public MojoDescriptor(PluginDescriptor pd, org.apache.maven.api.plugin.descriptor.MojoDescriptor md) {
        this();
        this.setPluginDescriptor(pd);
        this.setGoal(md.getGoal());
        this.setExecuteGoal(md.getExecuteGoal());
        this.setExecuteLifecycle(md.getExecuteLifecycle());
        this.setExecutePhase(md.getExecutePhase());
        this.setDeprecated(md.getDeprecated());
        this.setLanguage(md.getLanguage());
        this.setAggregator(md.isAggregator());
        this.setDependencyCollectionRequired(md.getDependencyCollection());
        this.setDependencyResolutionRequired(md.getDependencyResolution());
        this.setComponentConfigurator(md.getConfigurator());
        this.setInheritedByDefault(md.isInheritedByDefault());
        this.setPhase(md.getPhase());
        this.setOnlineRequired(md.isOnlineRequired());
        this.setProjectRequired(md.isProjectRequired());
        this.setSince(md.getSince());
        this.setThreadSafe(true);
        this.setV4Api(true);
        this.setImplementation(md.getImplementation());
        try {
            this.setParameters(md.getParameters().stream().map(Parameter::new).collect(Collectors.toList()));
        }
        catch (DuplicateParameterException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        this.mojoDescriptorV4 = md;
    }

    public String getLanguage() {
        return this.getComponentFactory();
    }

    public void setLanguage(String language) {
        this.setComponentFactory(language);
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(String deprecated) {
        this.deprecated = deprecated;
    }

    public List<Parameter> getParameters() {
        return new ArrayList<Parameter>(this.parameters);
    }

    public void setParameters(List<Parameter> parameters) throws DuplicateParameterException {
        this.parameters.clear();
        for (Parameter parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameter(Parameter parameter) throws DuplicateParameterException {
        if (this.parameters.contains(parameter)) {
            throw new DuplicateParameterException(parameter.getName() + " has been declared multiple times in mojo with goal: " + this.getGoal() + " (implementation: " + this.getImplementation() + ")");
        }
        this.parameters.add(parameter);
    }

    public Map<String, Parameter> getParameterMap() {
        LinkedHashMap<String, Parameter> parameterMap = new LinkedHashMap<String, Parameter>();
        for (Parameter pd : this.parameters) {
            parameterMap.put(pd.getName(), pd);
        }
        return parameterMap;
    }

    public void setDependencyResolutionRequired(String requiresDependencyResolution) {
        this.dependencyResolutionRequired = requiresDependencyResolution;
    }

    public String getDependencyResolutionRequired() {
        return this.dependencyResolutionRequired;
    }

    @Deprecated
    public String isDependencyResolutionRequired() {
        return this.dependencyResolutionRequired;
    }

    public void setDependencyCollectionRequired(String requiresDependencyCollection) {
        this.dependencyCollectionRequired = requiresDependencyCollection;
    }

    public String getDependencyCollectionRequired() {
        return this.dependencyCollectionRequired;
    }

    public void setProjectRequired(boolean requiresProject) {
        this.projectRequired = requiresProject;
    }

    public boolean isProjectRequired() {
        return this.projectRequired;
    }

    public void setOnlineRequired(boolean requiresOnline) {
        this.onlineRequired = requiresOnline;
    }

    public boolean isOnlineRequired() {
        return this.onlineRequired;
    }

    public boolean requiresOnline() {
        return this.onlineRequired;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getSince() {
        return this.since;
    }

    public void setSince(String since) {
        this.since = since;
    }

    public String getGoal() {
        return this.goal;
    }

    public void setGoal(String goal) {
        this.goal = goal;
    }

    public String getExecutePhase() {
        return this.executePhase;
    }

    public void setExecutePhase(String executePhase) {
        this.executePhase = executePhase;
    }

    public boolean alwaysExecute() {
        return MULTI_PASS_EXEC_STRATEGY.equals(this.executionStrategy);
    }

    public String getExecutionStrategy() {
        return this.executionStrategy;
    }

    public void setExecutionStrategy(String executionStrategy) {
        this.executionStrategy = executionStrategy;
    }

    public PlexusConfiguration getMojoConfiguration() {
        if (this.mojoConfiguration == null) {
            this.mojoConfiguration = new XmlPlexusConfiguration("configuration");
        }
        return this.mojoConfiguration;
    }

    public void setMojoConfiguration(PlexusConfiguration mojoConfiguration) {
        this.mojoConfiguration = mojoConfiguration;
    }

    public String getRole() {
        return this.isV4Api() ? "org.apache.maven.api.plugin.Mojo" : Mojo.ROLE;
    }

    public String getRoleHint() {
        return this.getId();
    }

    public String getId() {
        return this.getPluginDescriptor().getId() + ":" + this.getGoal();
    }

    public String getFullGoalName() {
        return this.getPluginDescriptor().getGoalPrefix() + ":" + this.getGoal();
    }

    public String getComponentType() {
        return MAVEN_PLUGIN;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.pluginDescriptor = pluginDescriptor;
    }

    public boolean isInheritedByDefault() {
        return this.inheritedByDefault;
    }

    public void setInheritedByDefault(boolean inheritedByDefault) {
        this.inheritedByDefault = inheritedByDefault;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MojoDescriptor) {
            MojoDescriptor other = (MojoDescriptor)object;
            return Objects.equals(this.getPluginDescriptor(), other.getPluginDescriptor()) && Objects.equals(this.getGoal(), other.getGoal());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getGoal(), this.getPluginDescriptor());
    }

    public String getExecuteLifecycle() {
        return this.executeLifecycle;
    }

    public void setExecuteLifecycle(String executeLifecycle) {
        this.executeLifecycle = executeLifecycle;
    }

    public void setAggregator(boolean aggregator) {
        this.aggregator = aggregator;
    }

    public boolean isAggregator() {
        return this.aggregator;
    }

    public boolean isDirectInvocationOnly() {
        return this.directInvocationOnly;
    }

    public void setDirectInvocationOnly(boolean directInvocationOnly) {
        this.directInvocationOnly = directInvocationOnly;
    }

    public boolean isRequiresReports() {
        return this.requiresReports;
    }

    public void setRequiresReports(boolean requiresReports) {
        this.requiresReports = requiresReports;
    }

    public void setExecuteGoal(String executeGoal) {
        this.executeGoal = executeGoal;
    }

    public String getExecuteGoal() {
        return this.executeGoal;
    }

    public boolean isThreadSafe() {
        return this.threadSafe;
    }

    public void setThreadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public boolean isForking() {
        return this.getExecuteGoal() != null && this.getExecuteGoal().length() > 0 || this.getExecutePhase() != null && this.getExecutePhase().length() > 0;
    }

    public boolean isV4Api() {
        return this.v4Api;
    }

    public void setV4Api(boolean v4Api) {
        this.v4Api = v4Api;
    }

    public MojoDescriptor clone() {
        try {
            return (MojoDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.apache.maven.api.plugin.descriptor.MojoDescriptor getMojoDescriptorV4() {
        if (this.mojoDescriptorV4 == null) {
            MojoDescriptor mojoDescriptor = this;
            synchronized (mojoDescriptor) {
                if (this.mojoDescriptorV4 == null) {
                    this.mojoDescriptorV4 = org.apache.maven.api.plugin.descriptor.MojoDescriptor.newBuilder().goal(this.goal).description(this.getDescription()).implementation(this.getImplementation()).language(this.getLanguage()).phase(this.phase).executeGoal(this.executeGoal).executeLifecycle(this.executeLifecycle).executePhase(this.executePhase).aggregator(this.aggregator).dependencyResolution(this.dependencyResolutionRequired).dependencyCollection(this.dependencyCollectionRequired).projectRequired(this.projectRequired).onlineRequired(this.onlineRequired).inheritedByDefault(this.inheritedByDefault).since(this.since).deprecated(this.deprecated).configurator(this.getComponentConfigurator()).parameters((Collection)this.getParameters().stream().filter(p -> p.getRequirement() == null).map(Parameter::getParameterV4).collect(Collectors.toList())).id(this.getId()).fullGoalName(this.getFullGoalName()).build();
                }
            }
        }
        return this.mojoDescriptorV4;
    }
}

