/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.descriptor.io;

import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.plugin.descriptor.Dependency;
import org.apache.maven.api.plugin.descriptor.MojoDescriptor;
import org.apache.maven.api.plugin.descriptor.Parameter;
import org.apache.maven.api.plugin.descriptor.PluginDescriptor;
import org.apache.maven.api.plugin.descriptor.Requirement;
import org.apache.maven.api.xml.XmlNode;
import org.codehaus.stax2.util.StreamWriterDelegate;

@Generated
public class PluginDescriptorStaxWriter {
    private static final String NAMESPACE = "http://maven.apache.org/PLUGIN/2.0.0";
    private static final String SCHEMA_LOCATION = "https://maven.apache.org/xsd/plugin-2.0.0.xsd";
    private String namespace = "http://maven.apache.org/PLUGIN/2.0.0";
    private String schemaLocation = "https://maven.apache.org/xsd/plugin-2.0.0.xsd";
    private String fileComment = null;

    public void setNamespace(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
    }

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, PluginDescriptor pluginDescriptor) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        factory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        factory.setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        serializer.writeStartDocument(pluginDescriptor.getModelEncoding(), null);
        this.writePluginDescriptor("plugin", pluginDescriptor, (XMLStreamWriter)((Object)serializer));
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, PluginDescriptor pluginDescriptor) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        factory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        factory.setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, pluginDescriptor.getModelEncoding()));
        serializer.writeStartDocument(pluginDescriptor.getModelEncoding(), null);
        this.writePluginDescriptor("plugin", pluginDescriptor, (XMLStreamWriter)((Object)serializer));
        serializer.writeEndDocument();
    }

    private void writePluginDescriptor(String tagName, PluginDescriptor pluginDescriptor, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginDescriptor != null) {
            if (this.fileComment != null) {
                serializer.writeCharacters("\n");
                serializer.writeComment(this.fileComment);
                serializer.writeCharacters("\n");
            }
            serializer.writeStartElement("", tagName, this.namespace);
            serializer.writeNamespace("", this.namespace);
            serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", this.namespace + " " + this.schemaLocation);
            this.writeTag("name", null, pluginDescriptor.getName(), serializer);
            this.writeTag("description", null, pluginDescriptor.getDescription(), serializer);
            this.writeTag("groupId", null, pluginDescriptor.getGroupId(), serializer);
            this.writeTag("artifactId", null, pluginDescriptor.getArtifactId(), serializer);
            this.writeTag("version", null, pluginDescriptor.getVersion(), serializer);
            this.writeTag("goalPrefix", null, pluginDescriptor.getGoalPrefix(), serializer);
            this.writeTag("isolatedRealm", "false", pluginDescriptor.isIsolatedRealm() ? "true" : null, serializer);
            this.writeTag("inheritedByDefault", "true", pluginDescriptor.isInheritedByDefault() ? null : "false", serializer);
            this.writeTag("requiredJavaVersion", null, pluginDescriptor.getRequiredJavaVersion(), serializer);
            this.writeTag("requiredMavenVersion", null, pluginDescriptor.getRequiredMavenVersion(), serializer);
            this.writeList("mojos", false, pluginDescriptor.getMojos(), serializer, t -> this.writeMojoDescriptor("mojo", (MojoDescriptor)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeMojoDescriptor(String tagName, MojoDescriptor mojoDescriptor, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (mojoDescriptor != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("goal", null, mojoDescriptor.getGoal(), serializer);
            this.writeTag("description", null, mojoDescriptor.getDescription(), serializer);
            this.writeTag("implementation", null, mojoDescriptor.getImplementation(), serializer);
            this.writeTag("language", "java", mojoDescriptor.getLanguage(), serializer);
            this.writeTag("phase", null, mojoDescriptor.getPhase(), serializer);
            this.writeTag("executePhase", null, mojoDescriptor.getExecutePhase(), serializer);
            this.writeTag("executeGoal", null, mojoDescriptor.getExecuteGoal(), serializer);
            this.writeTag("executeLifecycle", null, mojoDescriptor.getExecuteLifecycle(), serializer);
            this.writeTag("dependencyResolution", "runtime", mojoDescriptor.getDependencyResolution(), serializer);
            this.writeTag("dependencyCollection", null, mojoDescriptor.getDependencyCollection(), serializer);
            this.writeTag("directInvocationOnly", "false", mojoDescriptor.isDirectInvocationOnly() ? "true" : null, serializer);
            this.writeTag("projectRequired", "true", mojoDescriptor.isProjectRequired() ? null : "false", serializer);
            this.writeTag("onlineRequired", "false", mojoDescriptor.isOnlineRequired() ? "true" : null, serializer);
            this.writeTag("aggregator", "false", mojoDescriptor.isAggregator() ? "true" : null, serializer);
            this.writeTag("inheritedByDefault", "true", mojoDescriptor.isInheritedByDefault() ? null : "false", serializer);
            this.writeTag("since", null, mojoDescriptor.getSince(), serializer);
            this.writeTag("deprecated", null, mojoDescriptor.getDeprecated(), serializer);
            this.writeTag("configurator", null, mojoDescriptor.getConfigurator(), serializer);
            this.writeList("parameters", false, mojoDescriptor.getParameters(), serializer, t -> this.writeParameter("parameter", (Parameter)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeParameter(String tagName, Parameter parameter, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (parameter != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("name", null, parameter.getName(), serializer);
            this.writeTag("alias", null, parameter.getAlias(), serializer);
            this.writeTag("type", null, parameter.getType(), serializer);
            this.writeTag("required", "false", parameter.isRequired() ? "true" : null, serializer);
            this.writeTag("editable", "true", parameter.isEditable() ? null : "false", serializer);
            this.writeTag("description", null, parameter.getDescription(), serializer);
            this.writeTag("since", null, parameter.getSince(), serializer);
            this.writeTag("deprecated", null, parameter.getDeprecated(), serializer);
            this.writeTag("expression", null, parameter.getExpression(), serializer);
            this.writeTag("defaultValue", null, parameter.getDefaultValue(), serializer);
            serializer.writeEndElement();
        }
    }

    private void writeRequirement(String tagName, Requirement requirement, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (requirement != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("role", null, requirement.getRole(), serializer);
            this.writeTag("role-hint", null, requirement.getRoleHint(), serializer);
            this.writeTag("field-name", null, requirement.getFieldName(), serializer);
            serializer.writeEndElement();
        }
    }

    private void writeDependency(String tagName, Dependency dependency, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dependency != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("groupId", null, dependency.getGroupId(), serializer);
            this.writeTag("artifactId", null, dependency.getArtifactId(), serializer);
            this.writeTag("version", null, dependency.getVersion(), serializer);
            this.writeTag("type", "jar", dependency.getType(), serializer);
            serializer.writeEndElement();
        }
    }

    private <T> void writeList(String tagName, List<T> list, XMLStreamWriter serializer, ElementWriter<T> writer) throws IOException, XMLStreamException {
        this.writeList(tagName, false, list, serializer, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XMLStreamWriter serializer, ElementWriter<T> writer) throws IOException, XMLStreamException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.writeStartElement(this.namespace, tagName);
            }
            boolean index = false;
            for (T t : list) {
                writer.write(t);
            }
            if (!flat) {
                serializer.writeEndElement();
            }
        }
    }

    private <T> void writeProperties(String tagName, Map<String, String> props, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (props != null && !props.isEmpty()) {
            serializer.writeStartElement(this.namespace, tagName);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                this.writeTag(key, null, entry.getValue(), serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeDom(XmlNode dom, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dom != null) {
            serializer.writeStartElement(this.namespace, dom.getName());
            for (Map.Entry attr : dom.getAttributes().entrySet()) {
                if (((String)attr.getKey()).startsWith("xml:")) {
                    serializer.writeAttribute("http://www.w3.org/XML/1998/namespace", ((String)attr.getKey()).substring(4), (String)attr.getValue());
                    continue;
                }
                serializer.writeAttribute((String)attr.getKey(), (String)attr.getValue());
            }
            for (XmlNode child : dom.getChildren()) {
                this.writeDom(child, serializer);
            }
            String value = dom.getValue();
            if (value != null) {
                serializer.writeCharacters(value);
            }
            serializer.writeEndElement();
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.writeStartElement(this.namespace, tagName);
            serializer.writeCharacters(value);
            serializer.writeEndElement();
        }
    }

    private void writeAttr(String attrName, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null) {
            serializer.writeAttribute(attrName, value);
        }
    }

    static class IndentingXMLStreamWriter
    extends StreamWriterDelegate {
        int depth = 0;
        boolean hasChildren = false;

        public IndentingXMLStreamWriter(XMLStreamWriter parent) {
            super(parent);
        }

        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(localName);
            this.hasChildren = true;
        }

        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(namespaceURI, localName);
            this.hasChildren = true;
        }

        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(prefix, localName, namespaceURI);
            this.hasChildren = true;
        }

        public void writeStartElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(localName);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(namespaceURI, localName);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeStartElement(prefix, localName, namespaceURI);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeEndElement() throws XMLStreamException {
            --this.depth;
            if (this.hasChildren) {
                this.indent();
            }
            super.writeEndElement();
            this.hasChildren = true;
        }

        private void indent() throws XMLStreamException {
            super.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                super.writeCharacters("  ");
            }
        }
    }

    @FunctionalInterface
    private static interface ElementWriter<T> {
        public void write(T var1) throws IOException, XMLStreamException;
    }
}

