/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.java;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.RequirementMatcher;
import org.apache.maven.toolchain.RequirementMatcherFactory;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.apache.maven.toolchain.java.JavaToolchainImpl;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="jdk")
@Singleton
public class JavaToolchainFactory
implements ToolchainFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public ToolchainPrivate createToolchain(ToolchainModel model) throws MisconfiguredToolchainException {
        Xpp3Dom javahome;
        if (model == null) {
            return null;
        }
        DefaultJavaToolChain jtc = new DefaultJavaToolChain(model, this.logger);
        Properties provides = model.getProvides();
        for (Map.Entry<Object, Object> provide : provides.entrySet()) {
            String key = (String)provide.getKey();
            String value = (String)provide.getValue();
            if (value == null) {
                throw new MisconfiguredToolchainException("Provides token '" + key + "' doesn't have any value configured.");
            }
            RequirementMatcher matcher = "version".equals(key) ? RequirementMatcherFactory.createVersionMatcher(value) : RequirementMatcherFactory.createExactMatcher(value);
            jtc.addProvideToken(key, matcher);
        }
        Xpp3Dom dom = (Xpp3Dom)model.getConfiguration();
        Xpp3Dom xpp3Dom = javahome = dom != null ? dom.getChild("jdkHome") : null;
        if (javahome == null) {
            throw new MisconfiguredToolchainException("Java toolchain without the jdkHome configuration element.");
        }
        Path normal = Paths.get(javahome.getValue(), new String[0]).normalize();
        if (!Files.exists(normal, new LinkOption[0])) {
            throw new MisconfiguredToolchainException("Non-existing JDK home configuration at " + normal.toAbsolutePath());
        }
        ((JavaToolchainImpl)jtc).setJavaHome(Paths.get(javahome.getValue(), new String[0]).normalize().toString());
        return jtc;
    }

    @Override
    public ToolchainPrivate createDefaultToolchain() {
        return null;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

