/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.feature.Features;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ArtifactModelSource;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingListener;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.StringModelSource;
import org.apache.maven.model.building.TransformerContext;
import org.apache.maven.model.building.TransformerContextBuilder;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.root.RootLocator;
import org.apache.maven.project.CycleDetectedException;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultModelBuildingListener;
import org.apache.maven.project.DefaultProjectBuildingResult;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.ProjectModelResolver;
import org.apache.maven.project.ReactorModelPool;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.apache.maven.repository.internal.ModelCacheFactory;
import org.apache.maven.utils.Os;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultProjectBuilder
implements ProjectBuilder {
    public static final String BUILDER_PARALLELISM = "maven.projectBuilder.parallelism";
    public static final int DEFAULT_BUILDER_PARALLELISM = 4;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ModelBuilder modelBuilder;
    private final ModelProcessor modelProcessor;
    private final ProjectBuildingHelper projectBuildingHelper;
    private final MavenRepositorySystem repositorySystem;
    private final RepositorySystem repoSystem;
    private final RemoteRepositoryManager repositoryManager;
    private final ProjectDependenciesResolver dependencyResolver;
    private final ModelCacheFactory modelCacheFactory;
    private final RootLocator rootLocator;

    @Inject
    public DefaultProjectBuilder(ModelBuilder modelBuilder, ModelProcessor modelProcessor, ProjectBuildingHelper projectBuildingHelper, MavenRepositorySystem repositorySystem, RepositorySystem repoSystem, RemoteRepositoryManager repositoryManager, ProjectDependenciesResolver dependencyResolver, ModelCacheFactory modelCacheFactory, RootLocator rootLocator) {
        this.modelBuilder = modelBuilder;
        this.modelProcessor = modelProcessor;
        this.projectBuildingHelper = projectBuildingHelper;
        this.repositorySystem = repositorySystem;
        this.repoSystem = repoSystem;
        this.repositoryManager = repositoryManager;
        this.dependencyResolver = dependencyResolver;
        this.modelCacheFactory = modelCacheFactory;
        this.rootLocator = rootLocator;
    }

    @Override
    public ProjectBuildingResult build(File pomFile, ProjectBuildingRequest request) throws ProjectBuildingException {
        try (BuildSession bs = new BuildSession(request, false);){
            ProjectBuildingResult projectBuildingResult = bs.build(pomFile, (ModelSource)new FileModelSource(pomFile));
            return projectBuildingResult;
        }
    }

    @Override
    public ProjectBuildingResult build(ModelSource modelSource, ProjectBuildingRequest request) throws ProjectBuildingException {
        try (BuildSession bs = new BuildSession(request, false);){
            ProjectBuildingResult projectBuildingResult = bs.build(null, modelSource);
            return projectBuildingResult;
        }
    }

    @Override
    public ProjectBuildingResult build(Artifact artifact, ProjectBuildingRequest request) throws ProjectBuildingException {
        return this.build(artifact, false, request);
    }

    @Override
    public ProjectBuildingResult build(Artifact artifact, boolean allowStubModel, ProjectBuildingRequest request) throws ProjectBuildingException {
        try (BuildSession bs = new BuildSession(request, false);){
            ProjectBuildingResult projectBuildingResult = bs.build(artifact, allowStubModel);
            return projectBuildingResult;
        }
    }

    @Override
    public List<ProjectBuildingResult> build(List<File> pomFiles, boolean recursive, ProjectBuildingRequest request) throws ProjectBuildingException {
        try (BuildSession bs = new BuildSession(request, true);){
            List<ProjectBuildingResult> list = bs.build(pomFiles, recursive);
            return list;
        }
    }

    private List<String> getProfileIds(List<Profile> profiles) {
        return profiles.stream().map(Profile::getId).collect(Collectors.toList());
    }

    private static ModelSource createStubModelSource(Artifact artifact) {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("<?xml version='1.0'?>");
        buffer.append("<project>");
        buffer.append("<modelVersion>4.0.0</modelVersion>");
        buffer.append("<groupId>").append(artifact.getGroupId()).append("</groupId>");
        buffer.append("<artifactId>").append(artifact.getArtifactId()).append("</artifactId>");
        buffer.append("<version>").append(artifact.getBaseVersion()).append("</version>");
        buffer.append("<packaging>").append(artifact.getType()).append("</packaging>");
        buffer.append("</project>");
        return new StringModelSource((CharSequence)buffer, artifact.getId());
    }

    private static String inheritedGroupId(ModelBuildingResult result, int modelIndex) {
        String groupId = null;
        String modelId = (String)result.getModelIds().get(modelIndex);
        if (!modelId.isEmpty()) {
            Model model = result.getRawModel(modelId);
            groupId = model.getGroupId() != null ? model.getGroupId() : DefaultProjectBuilder.inheritedGroupId(result, modelIndex + 1);
        }
        return groupId;
    }

    private static String inheritedVersion(ModelBuildingResult result, int modelIndex) {
        String version = null;
        String modelId = (String)result.getModelIds().get(modelIndex);
        if (!modelId.isEmpty() && (version = result.getRawModel(modelId).getVersion()) == null) {
            version = DefaultProjectBuilder.inheritedVersion(result, modelIndex + 1);
        }
        return version;
    }

    static <T extends Throwable> void uncheckedThrow(Throwable t) throws T {
        throw t;
    }

    class BuildSession
    implements AutoCloseable {
        private final ProjectBuildingRequest request;
        private final RepositorySystemSession session;
        private final List<RemoteRepository> repositories;
        private final ReactorModelPool modelPool;
        private final TransformerContextBuilder transformerContextBuilder;
        private final ForkJoinPool forkJoinPool;

        BuildSession(ProjectBuildingRequest request, boolean localProjects) {
            this.request = request;
            this.session = RepositoryUtils.overlay(request.getLocalRepository(), request.getRepositorySession(), DefaultProjectBuilder.this.repoSystem);
            this.repositories = RepositoryUtils.toRepos(request.getRemoteRepositories());
            this.forkJoinPool = new ForkJoinPool(this.getParallelism(request));
            if (localProjects) {
                this.modelPool = new ReactorModelPool();
                this.transformerContextBuilder = DefaultProjectBuilder.this.modelBuilder.newTransformerContextBuilder();
            } else {
                this.modelPool = null;
                this.transformerContextBuilder = null;
            }
        }

        @Override
        public void close() {
            this.forkJoinPool.shutdownNow();
        }

        private int getParallelism(ProjectBuildingRequest request) {
            int parallelism = 4;
            try {
                String str = request.getUserProperties().getProperty(DefaultProjectBuilder.BUILDER_PARALLELISM);
                if (str == null) {
                    str = request.getSystemProperties().getProperty(DefaultProjectBuilder.BUILDER_PARALLELISM);
                }
                if (str != null) {
                    parallelism = Integer.parseInt(str);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Math.max(1, Math.min(parallelism, Runtime.getRuntime().availableProcessors()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProjectBuildingResult build(File pomFile, ModelSource modelSource) throws ProjectBuildingException {
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                MavenProject project = this.request.getProject();
                List modelProblems = null;
                ModelBuildingException error = null;
                if (project == null) {
                    ModelBuildingResult result;
                    ModelBuildingRequest request = this.getModelBuildingRequest();
                    project = new MavenProject();
                    project.setFile(pomFile);
                    DefaultModelBuildingListener listener = new DefaultModelBuildingListener(project, DefaultProjectBuilder.this.projectBuildingHelper, this.request);
                    request.setModelBuildingListener((ModelBuildingListener)listener);
                    request.setPomFile(pomFile);
                    request.setModelSource(modelSource);
                    request.setLocationTracking(true);
                    if (pomFile != null) {
                        project.setRootDirectory(DefaultProjectBuilder.this.rootLocator.findRoot(pomFile.getParentFile().toPath()));
                    }
                    try {
                        result = DefaultProjectBuilder.this.modelBuilder.build(request);
                    }
                    catch (ModelBuildingException e) {
                        result = e.getResult();
                        if (result == null || result.getEffectiveModel() == null) {
                            throw new ProjectBuildingException(e.getModelId(), e.getMessage(), pomFile, e);
                        }
                        error = e;
                    }
                    modelProblems = result.getProblems();
                    this.initProject(project, Collections.emptyMap(), result);
                } else if (this.request.isResolveDependencies()) {
                    DefaultProjectBuilder.this.projectBuildingHelper.selectProjectRealm(project);
                }
                DependencyResolutionResult resolutionResult = null;
                if (this.request.isResolveDependencies()) {
                    resolutionResult = this.resolveDependencies(project);
                }
                DefaultProjectBuildingResult result = new DefaultProjectBuildingResult(project, modelProblems, resolutionResult);
                if (error != null) {
                    ProjectBuildingException e = new ProjectBuildingException(Arrays.asList(result));
                    e.initCause(error);
                    throw e;
                }
                DefaultProjectBuildingResult defaultProjectBuildingResult = result;
                return defaultProjectBuildingResult;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            }
        }

        ProjectBuildingResult build(Artifact artifact, boolean allowStubModel) throws ProjectBuildingException {
            boolean localProject;
            org.eclipse.aether.artifact.Artifact pomArtifact = RepositoryUtils.toArtifact(artifact);
            pomArtifact = ArtifactDescriptorUtils.toPomArtifact((org.eclipse.aether.artifact.Artifact)pomArtifact);
            try {
                ArtifactRequest pomRequest = new ArtifactRequest();
                pomRequest.setArtifact(pomArtifact);
                pomRequest.setRepositories(this.repositories);
                ArtifactResult pomResult = DefaultProjectBuilder.this.repoSystem.resolveArtifact(this.session, pomRequest);
                pomArtifact = pomResult.getArtifact();
                localProject = pomResult.getRepository() instanceof WorkspaceRepository;
            }
            catch (ArtifactResolutionException e) {
                if (((ArtifactResult)e.getResults().get(0)).isMissing() && allowStubModel) {
                    return this.build(null, DefaultProjectBuilder.createStubModelSource(artifact));
                }
                throw new ProjectBuildingException(artifact.getId(), "Error resolving project artifact: " + e.getMessage(), e);
            }
            File pomFile = pomArtifact.getFile();
            if ("pom".equals(artifact.getType())) {
                artifact.selectVersion(pomArtifact.getVersion());
                artifact.setFile(pomFile);
                artifact.setResolved(true);
            }
            if (localProject) {
                return this.build(pomFile, (ModelSource)new FileModelSource(pomFile));
            }
            return this.build(null, (ModelSource)new ArtifactModelSource(pomFile, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        }

        List<ProjectBuildingResult> build(List<File> pomFiles, boolean recursive) throws ProjectBuildingException {
            List results;
            Future task = this.forkJoinPool.submit(() -> this.doBuild(pomFiles, recursive));
            ((ForkJoinTask)task).quietlyJoin();
            if (((ForkJoinTask)task).isCompletedAbnormally()) {
                Throwable e = ((ForkJoinTask)task).getException();
                Throwable c = e.getCause();
                DefaultProjectBuilder.uncheckedThrow(c != null && c.getClass() == e.getClass() ? c : e);
            }
            if ((results = (List)((ForkJoinTask)task).getRawResult()).stream().flatMap(r -> r.getProblems().stream()).anyMatch(p -> p.getSeverity() != ModelProblem.Severity.WARNING)) {
                ModelProblem cycle = results.stream().flatMap(r -> r.getProblems().stream()).filter(p -> p.getException() instanceof CycleDetectedException).findAny().orElse(null);
                if (cycle != null) {
                    throw new RuntimeException(new ProjectCycleException("The projects in the reactor contain a cyclic reference: " + cycle.getMessage(), (CycleDetectedException)cycle.getException()));
                }
                throw new ProjectBuildingException(results);
            }
            return results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<ProjectBuildingResult> doBuild(List<File> pomFiles, boolean recursive) {
            ConcurrentHashMap<File, MavenProject> projectIndex = new ConcurrentHashMap<File, MavenProject>(256);
            List<InterimResult> interimResults = this.build(projectIndex, pomFiles, new LinkedHashSet<File>(), true, recursive);
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                List<ProjectBuildingResult> results = this.build(projectIndex, interimResults);
                if (Features.buildConsumer((Properties)this.request.getUserProperties())) {
                    this.request.getRepositorySession().getData().set(TransformerContext.KEY, (Object)this.transformerContextBuilder.build());
                }
                List<ProjectBuildingResult> list = results;
                return list;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            }
        }

        private List<InterimResult> build(Map<File, MavenProject> projectIndex, List<File> pomFiles, Set<File> aggregatorFiles, boolean root, boolean recursive) {
            List tasks = pomFiles.stream().map(pomFile -> ForkJoinTask.adapt(() -> this.build(projectIndex, (File)pomFile, this.concat(aggregatorFiles, pomFile), root, recursive))).collect(Collectors.toList());
            return ForkJoinTask.invokeAll(tasks).stream().map(ForkJoinTask::getRawResult).collect(Collectors.toList());
        }

        private <T> Set<T> concat(Set<T> set, T elem) {
            HashSet<T> newSet = new HashSet<T>(set);
            newSet.add(elem);
            return newSet;
        }

        private InterimResult build(Map<File, MavenProject> projectIndex, File pomFile, Set<File> aggregatorFiles, boolean isRoot, boolean recursive) {
            ModelBuildingResult result;
            ModelBuildingRequest modelBuildingRequest;
            MavenProject project;
            block12: {
                project = new MavenProject();
                project.setFile(pomFile);
                project.setRootDirectory(DefaultProjectBuilder.this.rootLocator.findRoot(pomFile.getParentFile().toPath()));
                modelBuildingRequest = this.getModelBuildingRequest().setPomFile(pomFile).setTwoPhaseBuilding(true).setLocationTracking(true);
                DefaultModelBuildingListener listener = new DefaultModelBuildingListener(project, DefaultProjectBuilder.this.projectBuildingHelper, this.request);
                modelBuildingRequest.setModelBuildingListener((ModelBuildingListener)listener);
                try {
                    result = DefaultProjectBuilder.this.modelBuilder.build(modelBuildingRequest);
                }
                catch (ModelBuildingException e) {
                    result = e.getResult();
                    if (result != null && result.getFileModel() != null) break block12;
                    return new InterimResult(modelBuildingRequest, new DefaultProjectBuildingResult(e.getModelId(), pomFile, e.getProblems()));
                }
            }
            Model model = modelBuildingRequest.getFileModel();
            this.modelPool.put(model.getPomFile().toPath(), model);
            InterimResult interimResult = new InterimResult(pomFile, modelBuildingRequest, result, project, isRoot);
            if (recursive) {
                File basedir = pomFile.getParentFile();
                ArrayList<File> moduleFiles = new ArrayList<File>();
                for (String module : model.getModules()) {
                    if (module == null || module.isEmpty()) continue;
                    module = module.replace('\\', File.separatorChar).replace('/', File.separatorChar);
                    File moduleFile = DefaultProjectBuilder.this.modelProcessor.locateExistingPom(new File(basedir, module));
                    if (moduleFile == null) {
                        DefaultModelProblem problem = new DefaultModelProblem("Child module " + moduleFile + " of " + pomFile + " does not exist", ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, model, -1, -1, null);
                        result.getProblems().add(problem);
                        continue;
                    }
                    if (Os.IS_WINDOWS) {
                        try {
                            moduleFile = moduleFile.getCanonicalFile();
                        }
                        catch (IOException e) {
                            moduleFile = moduleFile.getAbsoluteFile();
                        }
                    } else {
                        moduleFile = new File(moduleFile.toURI().normalize());
                    }
                    if (aggregatorFiles.contains(moduleFile)) {
                        StringBuilder buffer = new StringBuilder(256);
                        for (File aggregatorFile : aggregatorFiles) {
                            buffer.append(aggregatorFile).append(" -> ");
                        }
                        buffer.append(moduleFile);
                        DefaultModelProblem problem = new DefaultModelProblem("Child module " + moduleFile + " of " + pomFile + " forms aggregation cycle " + buffer, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, model, -1, -1, null);
                        result.getProblems().add(problem);
                        continue;
                    }
                    moduleFiles.add(moduleFile);
                }
                if (!moduleFiles.isEmpty()) {
                    interimResult.modules = this.build(projectIndex, moduleFiles, aggregatorFiles, false, recursive);
                }
            }
            projectIndex.put(pomFile, project);
            return interimResult;
        }

        private List<ProjectBuildingResult> build(Map<File, MavenProject> projectIndex, List<InterimResult> interimResults) {
            if (DefaultProjectBuilder.this.modelBuilder instanceof DefaultModelBuilder) {
                ArrayList<ProjectBuildingResult> results = new ArrayList<ProjectBuildingResult>();
                DefaultModelBuilder dmb = (DefaultModelBuilder)DefaultProjectBuilder.this.modelBuilder;
                boolean failure = false;
                for (InterimResult r : interimResults) {
                    DefaultProjectBuildingResult res;
                    try {
                        Model model = dmb.buildRawModel(r.request);
                        res = new DefaultProjectBuildingResult(model.getId(), model.getPomFile(), null);
                    }
                    catch (ModelBuildingException e) {
                        failure = true;
                        res = new DefaultProjectBuildingResult(e.getModelId(), r.request.getPomFile(), e.getProblems());
                    }
                    results.add(res);
                }
                if (failure) {
                    return results;
                }
            }
            return interimResults.parallelStream().map(interimResult -> this.doBuild(projectIndex, (InterimResult)interimResult)).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private List<ProjectBuildingResult> doBuild(Map<File, MavenProject> projectIndex, InterimResult interimResult) {
            if (interimResult.projectBuildingResult != null) {
                return Collections.singletonList(interimResult.projectBuildingResult);
            }
            MavenProject project = interimResult.project;
            try {
                ModelBuildingResult result = DefaultProjectBuilder.this.modelBuilder.build(interimResult.request, interimResult.result);
                try {
                    this.initProject(project, projectIndex, result);
                }
                catch (InvalidArtifactRTException iarte) {
                    result.getProblems().add(new DefaultModelProblem(null, ModelProblem.Severity.ERROR, null, result.getEffectiveModel(), -1, -1, (Exception)((Object)iarte)));
                }
                List<ProjectBuildingResult> results = this.build(projectIndex, interimResult.modules);
                project.setExecutionRoot(interimResult.root);
                project.setCollectedProjects(results.stream().map(ProjectBuildingResult::getProject).collect(Collectors.toList()));
                DependencyResolutionResult resolutionResult = null;
                if (this.request.isResolveDependencies()) {
                    resolutionResult = this.resolveDependencies(project);
                }
                results.add(new DefaultProjectBuildingResult(project, result.getProblems(), resolutionResult));
                return results;
            }
            catch (ModelBuildingException e) {
                DefaultProjectBuildingResult result;
                if (project == null || interimResult.result.getEffectiveModel() == null) {
                    result = new DefaultProjectBuildingResult(e.getModelId(), interimResult.pomFile, e.getProblems());
                } else {
                    project.setModel(interimResult.result.getEffectiveModel());
                    result = new DefaultProjectBuildingResult(project, e.getProblems(), null);
                }
                return Collections.singletonList(result);
            }
        }

        private void initProject(MavenProject project, Map<File, MavenProject> projects, ModelBuildingResult result) {
            ArtifactRepository repo;
            DeploymentRepository r;
            project.setModel(result.getEffectiveModel());
            project.setOriginalModel(result.getFileModel());
            this.initParent(project, projects, result);
            Artifact projectArtifact = DefaultProjectBuilder.this.repositorySystem.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, project.getPackaging());
            project.setArtifact(projectArtifact);
            if (project.getFile() != null) {
                Build build = project.getBuild();
                project.addScriptSourceRoot(build.getScriptSourceDirectory());
                project.addCompileSourceRoot(build.getSourceDirectory());
                project.addTestCompileSourceRoot(build.getTestSourceDirectory());
            }
            ArrayList<Profile> activeProfiles = new ArrayList<Profile>();
            activeProfiles.addAll(result.getActivePomProfiles((String)result.getModelIds().get(0)));
            activeProfiles.addAll(result.getActiveExternalProfiles());
            project.setActiveProfiles(activeProfiles);
            project.setInjectedProfileIds("external", DefaultProjectBuilder.this.getProfileIds(result.getActiveExternalProfiles()));
            for (Object modelId : result.getModelIds()) {
                project.setInjectedProfileIds((String)modelId, DefaultProjectBuilder.this.getProfileIds(result.getActivePomProfiles((String)modelId)));
            }
            project.setProjectBuildingRequest(this.request);
            HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
            for (Plugin plugin : project.getBuildPlugins()) {
                Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createPluginArtifact(plugin);
                if (artifact == null) continue;
                pluginArtifacts.add(artifact);
            }
            project.setPluginArtifacts(pluginArtifacts);
            HashSet<Artifact> reportArtifacts = new HashSet<Artifact>();
            for (ReportPlugin report : project.getReportPlugins()) {
                Plugin pp = new Plugin();
                pp.setGroupId(report.getGroupId());
                pp.setArtifactId(report.getArtifactId());
                pp.setVersion(report.getVersion());
                Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createPluginArtifact(pp);
                if (artifact == null) continue;
                reportArtifacts.add(artifact);
            }
            project.setReportArtifacts(reportArtifacts);
            HashSet<Artifact> hashSet = new HashSet<Artifact>();
            List<Extension> extensions = project.getBuildExtensions();
            if (extensions != null) {
                for (Extension ext : extensions) {
                    String version = ext.getVersion() == null || ext.getVersion().isEmpty() ? "RELEASE" : ext.getVersion();
                    Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createArtifact(ext.getGroupId(), ext.getArtifactId(), version, null, "jar");
                    if (artifact == null) continue;
                    hashSet.add(artifact);
                }
            }
            project.setExtensionArtifacts(hashSet);
            Map<String, Artifact> map = Collections.emptyMap();
            DependencyManagement dependencyManagement = project.getDependencyManagement();
            if (dependencyManagement != null && dependencyManagement.getDependencies() != null && !dependencyManagement.getDependencies().isEmpty()) {
                map = new LazyMap<String, Artifact>(() -> {
                    HashMap<String, Artifact> tmp = new HashMap<String, Artifact>();
                    for (Dependency d : dependencyManagement.getDependencies()) {
                        Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createDependencyArtifact(d);
                        if (artifact == null) continue;
                        tmp.put(d.getManagementKey(), artifact);
                    }
                    return Collections.unmodifiableMap(tmp);
                });
            }
            project.setManagedVersionMap(map);
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getRepository() != null) {
                try {
                    r = project.getDistributionManagement().getRepository();
                    if (r.getId() != null && !r.getId().isEmpty() && r.getUrl() != null && !r.getUrl().isEmpty()) {
                        repo = MavenRepositorySystem.buildArtifactRepository((Repository)r);
                        DefaultProjectBuilder.this.repositorySystem.injectProxy(this.request.getRepositorySession(), Arrays.asList(repo));
                        DefaultProjectBuilder.this.repositorySystem.injectAuthentication(this.request.getRepositorySession(), Arrays.asList(repo));
                        project.setReleaseArtifactRepository(repo);
                    }
                }
                catch (InvalidRepositoryException e) {
                    throw new IllegalStateException("Failed to create release distribution repository for " + project.getId(), e);
                }
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getSnapshotRepository() != null) {
                try {
                    r = project.getDistributionManagement().getSnapshotRepository();
                    if (r.getId() != null && !r.getId().isEmpty() && r.getUrl() != null && !r.getUrl().isEmpty()) {
                        repo = MavenRepositorySystem.buildArtifactRepository((Repository)r);
                        DefaultProjectBuilder.this.repositorySystem.injectProxy(this.request.getRepositorySession(), Arrays.asList(repo));
                        DefaultProjectBuilder.this.repositorySystem.injectAuthentication(this.request.getRepositorySession(), Arrays.asList(repo));
                        project.setSnapshotArtifactRepository(repo);
                    }
                }
                catch (InvalidRepositoryException e) {
                    throw new IllegalStateException("Failed to create snapshot distribution repository for " + project.getId(), e);
                }
            }
        }

        private void initParent(MavenProject project, Map<File, MavenProject> projects, ModelBuildingResult result) {
            Model parentModel;
            Model model = parentModel = result.getModelIds().size() > 1 && !((String)result.getModelIds().get(1)).isEmpty() ? result.getRawModel((String)result.getModelIds().get(1)) : null;
            if (parentModel != null) {
                MavenProject parent;
                block11: {
                    String parentGroupId = DefaultProjectBuilder.inheritedGroupId(result, 1);
                    String parentVersion = DefaultProjectBuilder.inheritedVersion(result, 1);
                    project.setParentArtifact(DefaultProjectBuilder.this.repositorySystem.createProjectArtifact(parentGroupId, parentModel.getArtifactId(), parentVersion));
                    String parentModelId = (String)result.getModelIds().get(1);
                    File parentPomFile = result.getRawModel(parentModelId).getPomFile();
                    MavenProject mavenProject = parent = parentPomFile != null ? projects.get(parentPomFile) : null;
                    if (parent == null) {
                        this.request.setRemoteRepositories(project.getRemoteArtifactRepositories());
                        if (parentPomFile != null) {
                            project.setParentFile(parentPomFile);
                            try {
                                parent = this.build(parentPomFile, (ModelSource)new FileModelSource(parentPomFile)).getProject();
                            }
                            catch (ProjectBuildingException e) {
                                if (DefaultProjectBuilder.this.logger.isDebugEnabled()) {
                                    DefaultProjectBuilder.this.logger.warn("Failed to build parent project for " + project.getId(), (Throwable)e);
                                    break block11;
                                }
                                DefaultProjectBuilder.this.logger.warn("Failed to build parent project for " + project.getId());
                            }
                        } else {
                            Artifact parentArtifact = project.getParentArtifact();
                            try {
                                parent = this.build(parentArtifact, false).getProject();
                            }
                            catch (ProjectBuildingException e) {
                                if (DefaultProjectBuilder.this.logger.isDebugEnabled()) {
                                    DefaultProjectBuilder.this.logger.warn("Failed to build parent project for " + project.getId(), (Throwable)e);
                                }
                                DefaultProjectBuilder.this.logger.warn("Failed to build parent project for " + project.getId());
                            }
                        }
                    }
                }
                project.setParent(parent);
                if (project.getParentFile() == null && parent != null) {
                    project.setParentFile(parent.getFile());
                }
            }
        }

        private ModelBuildingRequest getModelBuildingRequest() {
            DefaultModelBuildingRequest modelBuildingRequest = new DefaultModelBuildingRequest();
            RequestTrace trace = RequestTrace.newChild(null, (Object)this.request).newChild((Object)modelBuildingRequest);
            ProjectModelResolver resolver = new ProjectModelResolver(this.session, trace, DefaultProjectBuilder.this.repoSystem, DefaultProjectBuilder.this.repositoryManager, this.repositories, this.request.getRepositoryMerging(), this.modelPool);
            modelBuildingRequest.setValidationLevel(this.request.getValidationLevel());
            modelBuildingRequest.setProcessPlugins(this.request.isProcessPlugins());
            modelBuildingRequest.setProfiles(this.request.getProfiles());
            modelBuildingRequest.setActiveProfileIds(this.request.getActiveProfileIds());
            modelBuildingRequest.setInactiveProfileIds(this.request.getInactiveProfileIds());
            modelBuildingRequest.setSystemProperties(this.request.getSystemProperties());
            modelBuildingRequest.setUserProperties(this.request.getUserProperties());
            modelBuildingRequest.setBuildStartTime(this.request.getBuildStartTime());
            modelBuildingRequest.setModelResolver((ModelResolver)resolver);
            if (this.modelPool != null) {
                modelBuildingRequest.setModelCache(DefaultProjectBuilder.this.modelCacheFactory.createCache(this.session));
            }
            modelBuildingRequest.setTransformerContextBuilder(this.transformerContextBuilder);
            InternalSession session = (InternalSession)this.session.getData().get(InternalSession.class);
            if (session != null) {
                try {
                    modelBuildingRequest.setRootDirectory(session.getRootDirectory());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return modelBuildingRequest;
        }

        private DependencyResolutionResult resolveDependencies(MavenProject project) {
            DependencyResolutionResult resolutionResult;
            try {
                DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, this.session);
                resolutionResult = DefaultProjectBuilder.this.dependencyResolver.resolve(resolution);
            }
            catch (DependencyResolutionException e) {
                resolutionResult = e.getResult();
            }
            LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
            if (resolutionResult.getDependencyGraph() != null) {
                RepositoryUtils.toArtifacts(artifacts, resolutionResult.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), null);
                LocalRepositoryManager lrm = this.session.getLocalRepositoryManager();
                for (Artifact artifact : artifacts) {
                    if (artifact.isResolved()) continue;
                    String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact(artifact));
                    artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
                }
            }
            project.setResolvedArtifacts(artifacts);
            project.setArtifacts(artifacts);
            return resolutionResult;
        }
    }

    static class LazyMap<K, V>
    extends AbstractMap<K, V> {
        private final Supplier<Map<K, V>> supplier;
        private volatile Map<K, V> delegate;

        LazyMap(Supplier<Map<K, V>> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.delegate == null) {
                LazyMap lazyMap = this;
                synchronized (lazyMap) {
                    if (this.delegate == null) {
                        this.delegate = this.supplier.get();
                    }
                }
            }
            return this.delegate.entrySet();
        }
    }

    static class InterimResult {
        File pomFile;
        ModelBuildingRequest request;
        ModelBuildingResult result;
        MavenProject project;
        boolean root;
        List<InterimResult> modules = Collections.emptyList();
        ProjectBuildingResult projectBuildingResult;

        InterimResult(File pomFile, ModelBuildingRequest request, ModelBuildingResult result, MavenProject project, boolean root) {
            this.pomFile = pomFile;
            this.request = request;
            this.result = result;
            this.project = project;
            this.root = root;
        }

        InterimResult(ModelBuildingRequest request, ProjectBuildingResult projectBuildingResult) {
            this.request = request;
            this.projectBuildingResult = projectBuildingResult;
            this.pomFile = projectBuildingResult.getPomFile();
            this.project = projectBuildingResult.getProject();
        }
    }
}

