/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Repository;
import org.apache.maven.api.Version;
import org.apache.maven.api.services.VersionResolver;
import org.apache.maven.api.services.VersionResolverException;
import org.apache.maven.api.services.VersionResolverRequest;
import org.apache.maven.api.services.VersionResolverResult;
import org.apache.maven.internal.impl.DefaultLocalRepository;
import org.apache.maven.internal.impl.DefaultRemoteRepository;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;

@Named
@Singleton
public class DefaultVersionResolver
implements VersionResolver {
    private final RepositorySystem repositorySystem;

    @Inject
    public DefaultVersionResolver(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    public VersionResolverResult resolve(VersionResolverRequest request) throws VersionResolverException {
        Utils.nonNull(request, "request");
        final InternalSession session = InternalSession.from(request.getSession());
        try {
            final VersionResult res = this.repositorySystem.resolveVersion(session.getSession(), new VersionRequest(session.toArtifact(request.getArtifactCoordinate()), session.toRepositories(session.getRemoteRepositories()), null));
            return new VersionResolverResult(){

                public List<Exception> getExceptions() {
                    return res.getExceptions();
                }

                public Version getVersion() {
                    return session.parseVersion(res.getVersion());
                }

                public Optional<Repository> getRepository() {
                    if (res.getRepository() instanceof LocalRepository) {
                        return Optional.of(new DefaultLocalRepository((LocalRepository)res.getRepository()));
                    }
                    if (res.getRepository() instanceof RemoteRepository) {
                        return Optional.of(new DefaultRemoteRepository((RemoteRepository)res.getRepository()));
                    }
                    return Optional.empty();
                }
            };
        }
        catch (VersionResolutionException e) {
            throw new VersionResolverException("Unable to resolve version", (Throwable)e);
        }
    }
}

