/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Version;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.internal.impl.Utils;

@Named
@Singleton
public class DefaultVersionParser
implements VersionParser {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}\\.[0-9]{6}-[0-9]+)$");
    private final org.apache.maven.model.version.VersionParser modelVersionParser;

    @Inject
    public DefaultVersionParser(org.apache.maven.model.version.VersionParser modelVersionParser) {
        this.modelVersionParser = Utils.nonNull(modelVersionParser, "modelVersionParser");
    }

    public Version parseVersion(String version) {
        return this.modelVersionParser.parseVersion(version);
    }

    public VersionRange parseVersionRange(String range) {
        return this.modelVersionParser.parseVersionRange(range);
    }

    public boolean isSnapshot(String version) {
        return DefaultVersionParser.checkSnapshot(version);
    }

    static boolean checkSnapshot(String version) {
        return version.endsWith(SNAPSHOT) || SNAPSHOT_TIMESTAMP.matcher(version).matches();
    }
}

