/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Type;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.LegacyArtifactHandlerManager;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.internal.impl.DefaultDependencyProperties;
import org.apache.maven.internal.impl.DefaultType;
import org.apache.maven.internal.impl.Utils;

@Named
@Singleton
public class DefaultTypeRegistry
extends AbstractEventSpy
implements TypeRegistry {
    private final Map<String, Type> types;
    private final ConcurrentHashMap<String, Type> usedTypes;
    private final ConcurrentHashMap<String, Type> legacyTypes;
    private final LegacyArtifactHandlerManager manager;

    @Inject
    public DefaultTypeRegistry(Map<String, Type> types, LegacyArtifactHandlerManager manager) {
        this.types = Utils.nonNull(types, "types");
        this.usedTypes = new ConcurrentHashMap();
        this.legacyTypes = new ConcurrentHashMap();
        this.manager = Utils.nonNull(manager, "artifactHandlerManager");
    }

    @Override
    public void onEvent(Object event) {
        ExecutionEvent executionEvent;
        if (event instanceof ExecutionEvent && (executionEvent = (ExecutionEvent)event).getType() == ExecutionEvent.Type.SessionEnded) {
            this.usedTypes.clear();
            this.legacyTypes.clear();
        }
    }

    @Nonnull
    public Type getType(String id) {
        Utils.nonNull(id, "id");
        return this.usedTypes.computeIfAbsent(id, i -> {
            Type type = this.types.get(id);
            if (type == null) {
                type = this.legacyTypes.computeIfAbsent(id, k -> {
                    ArtifactHandler handler = this.manager.getArtifactHandler(id);
                    ArrayList<String> flags = new ArrayList<String>();
                    if (handler.isAddedToClasspath()) {
                        flags.add("classPathConstituent");
                    }
                    if (handler.isIncludesDependencies()) {
                        flags.add("includesDependencies");
                    }
                    return new DefaultType(id, handler.getLanguage(), handler.getExtension(), handler.getClassifier(), new DefaultDependencyProperties(flags));
                });
            }
            return type;
        });
    }
}

