/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.ToolchainsBuilderException;
import org.apache.maven.api.services.ToolchainsBuilderRequest;
import org.apache.maven.api.services.ToolchainsBuilderResult;
import org.apache.maven.api.toolchain.PersistedToolchains;
import org.apache.maven.building.FileSource;
import org.apache.maven.building.Problem;
import org.apache.maven.internal.impl.MappedList;
import org.apache.maven.toolchain.building.DefaultToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuilder;
import org.apache.maven.toolchain.building.ToolchainsBuildingException;
import org.apache.maven.toolchain.building.ToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuildingResult;

@Named
@Singleton
public class DefaultToolchainsBuilder
implements org.apache.maven.api.services.ToolchainsBuilder {
    private final ToolchainsBuilder builder;

    @Inject
    public DefaultToolchainsBuilder(ToolchainsBuilder builder) {
        this.builder = builder;
    }

    @Nonnull
    public ToolchainsBuilderResult build(ToolchainsBuilderRequest request) throws ToolchainsBuilderException, IllegalArgumentException {
        try {
            DefaultToolchainsBuildingRequest req = new DefaultToolchainsBuildingRequest();
            if (request.getGlobalToolchainsSource().isPresent()) {
                req.setGlobalToolchainsSource((org.apache.maven.building.Source)new MappedToolchainsSource((Source)request.getGlobalToolchainsSource().get()));
            } else if (request.getGlobalToolchainsPath().isPresent()) {
                req.setGlobalToolchainsSource((org.apache.maven.building.Source)new FileSource(((Path)request.getGlobalToolchainsPath().get()).toFile()));
            }
            if (request.getUserToolchainsSource().isPresent()) {
                req.setUserToolchainsSource((org.apache.maven.building.Source)new MappedToolchainsSource((Source)request.getUserToolchainsSource().get()));
            } else if (request.getUserToolchainsPath().isPresent()) {
                req.setUserToolchainsSource((org.apache.maven.building.Source)new FileSource(((Path)request.getUserToolchainsPath().get()).toFile()));
            }
            final ToolchainsBuildingResult result = this.builder.build((ToolchainsBuildingRequest)req);
            return new ToolchainsBuilderResult(){

                public PersistedToolchains getEffectiveToolchains() {
                    return result.getEffectiveToolchains().getDelegate();
                }

                public List<BuilderProblem> getProblems() {
                    return new MappedList<BuilderProblem, Problem>(result.getProblems(), MappedBuilderProblem::new);
                }
            };
        }
        catch (ToolchainsBuildingException e) {
            throw new ToolchainsBuilderException("Unable to build Toolchains", (Exception)((Object)e));
        }
    }

    private static class MappedToolchainsSource
    implements org.apache.maven.building.Source {
        private final Source source;

        MappedToolchainsSource(Source source) {
            this.source = source;
        }

        public InputStream getInputStream() throws IOException {
            return this.source.openStream();
        }

        public String getLocation() {
            return this.source.getLocation();
        }
    }

    private static class MappedBuilderProblem
    implements BuilderProblem {
        private final Problem problem;

        MappedBuilderProblem(Problem problem) {
            this.problem = problem;
        }

        public String getSource() {
            return this.problem.getSource();
        }

        public int getLineNumber() {
            return this.problem.getLineNumber();
        }

        public int getColumnNumber() {
            return this.problem.getColumnNumber();
        }

        public String getLocation() {
            return this.problem.getLocation();
        }

        public Exception getException() {
            return this.problem.getException();
        }

        public String getMessage() {
            return this.problem.getMessage();
        }

        public BuilderProblem.Severity getSeverity() {
            return BuilderProblem.Severity.valueOf((String)this.problem.getSeverity().name());
        }
    }
}

