/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.SessionScoped;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.internal.impl.DefaultProject;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.sisu.Typed;

@Named
@Typed
@SessionScoped
public class DefaultProjectManager
implements ProjectManager {
    private final InternalSession session;
    private final ArtifactManager artifactManager;
    private final PlexusContainer container;

    @Inject
    public DefaultProjectManager(InternalSession session, ArtifactManager artifactManager, PlexusContainer container) {
        this.session = session;
        this.artifactManager = artifactManager;
        this.container = container;
    }

    @Nonnull
    public Optional<Path> getPath(Project project) {
        return this.artifactManager.getPath(project.getArtifact());
    }

    @Nonnull
    public Collection<Artifact> getAttachedArtifacts(Project project) {
        InternalSession session = ((DefaultProject)project).getSession();
        List<Artifact> attached = Utils.map(this.getMavenProject(project).getAttachedArtifacts(), a -> session.getArtifact(RepositoryUtils.toArtifact(a)));
        return Collections.unmodifiableCollection(attached);
    }

    public void attachArtifact(Project project, Artifact artifact, Path path) {
        this.getMavenProject(project).addAttachedArtifact(RepositoryUtils.toArtifact(((DefaultProject)project).getSession().toArtifact(artifact)));
        this.artifactManager.setPath(artifact, path);
    }

    public List<String> getCompileSourceRoots(Project project) {
        List<String> roots = this.getMavenProject(project).getCompileSourceRoots();
        return Collections.unmodifiableList(roots);
    }

    public void addCompileSourceRoot(Project project, String sourceRoot) {
        List<String> roots = this.getMavenProject(project).getCompileSourceRoots();
        roots.add(sourceRoot);
    }

    public List<String> getTestCompileSourceRoots(Project project) {
        List<String> roots = this.getMavenProject(project).getTestCompileSourceRoots();
        return Collections.unmodifiableList(roots);
    }

    public void addTestCompileSourceRoot(Project project, String sourceRoot) {
        List<String> roots = this.getMavenProject(project).getTestCompileSourceRoots();
        roots.add(sourceRoot);
    }

    public List<RemoteRepository> getRepositories(Project project) {
        return ((DefaultProject)project).getProject().getRemoteProjectRepositories().stream().map(this.session::getRemoteRepository).collect(Collectors.toList());
    }

    public void setProperty(Project project, String key, String value) {
        this.getMavenProject(project).getProperties().setProperty(key, value);
    }

    private MavenProject getMavenProject(Project project) {
        return ((DefaultProject)project).getProject();
    }
}

