/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.Exclusion;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Scope;
import org.apache.maven.api.Type;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.MappedCollection;
import org.apache.maven.internal.impl.MappedList;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;

public class DefaultProject
implements Project {
    private final InternalSession session;
    private final MavenProject project;

    public DefaultProject(InternalSession session, MavenProject project) {
        this.session = session;
        this.project = project;
    }

    public InternalSession getSession() {
        return this.session;
    }

    public MavenProject getProject() {
        return this.project;
    }

    @Nonnull
    public String getGroupId() {
        return this.project.getGroupId();
    }

    @Nonnull
    public String getArtifactId() {
        return this.project.getArtifactId();
    }

    @Nonnull
    public String getVersion() {
        return this.project.getVersion();
    }

    @Nonnull
    public org.apache.maven.api.Artifact getArtifact() {
        Artifact resolverArtifact = RepositoryUtils.toArtifact(this.project.getArtifact());
        org.apache.maven.api.Artifact artifact = this.session.getArtifact(resolverArtifact);
        Path path = resolverArtifact.getFile() != null ? resolverArtifact.getFile().toPath() : null;
        ((ArtifactManager)this.session.getService(ArtifactManager.class)).setPath(artifact, path);
        return artifact;
    }

    @Nonnull
    public String getPackaging() {
        return this.project.getPackaging();
    }

    @Nonnull
    public Model getModel() {
        return this.project.getModel().getDelegate();
    }

    @Nonnull
    public Optional<Path> getPomPath() {
        File file = this.project.getFile();
        return Optional.ofNullable(file).map(File::toPath);
    }

    @Nonnull
    public List<DependencyCoordinate> getDependencies() {
        return new MappedList<DependencyCoordinate, Dependency>(this.getModel().getDependencies(), this::toDependency);
    }

    @Nonnull
    public List<DependencyCoordinate> getManagedDependencies() {
        DependencyManagement dependencyManagement = this.getModel().getDependencyManagement();
        if (dependencyManagement != null) {
            return new MappedList<DependencyCoordinate, Dependency>(dependencyManagement.getDependencies(), this::toDependency);
        }
        return Collections.emptyList();
    }

    public boolean isExecutionRoot() {
        return this.project.isExecutionRoot();
    }

    public boolean isTopProject() {
        return this.getBasedir().isPresent() && ((Path)this.getBasedir().get()).equals(this.getSession().getTopDirectory());
    }

    public boolean isRootProject() {
        return this.getBasedir().isPresent() && ((Path)this.getBasedir().get()).equals(this.getRootDirectory());
    }

    public Path getRootDirectory() {
        return this.project.getRootDirectory();
    }

    public Optional<Project> getParent() {
        MavenProject parent = this.project.getParent();
        return parent != null ? Optional.of(this.session.getProject(parent)) : Optional.empty();
    }

    public List<RemoteRepository> getRemoteProjectRepositories() {
        return new MappedList<RemoteRepository, org.eclipse.aether.repository.RemoteRepository>(this.project.getRemoteProjectRepositories(), this.session::getRemoteRepository);
    }

    public List<RemoteRepository> getRemotePluginRepositories() {
        return new MappedList<RemoteRepository, org.eclipse.aether.repository.RemoteRepository>(this.project.getRemotePluginRepositories(), this.session::getRemoteRepository);
    }

    @Nonnull
    private DependencyCoordinate toDependency(final Dependency dependency) {
        return new DependencyCoordinate(){

            public String getGroupId() {
                return dependency.getGroupId();
            }

            public String getArtifactId() {
                return dependency.getArtifactId();
            }

            public String getClassifier() {
                return dependency.getClassifier();
            }

            public VersionRange getVersion() {
                return DefaultProject.this.session.parseVersionRange(dependency.getVersion());
            }

            public String getExtension() {
                return this.getType().getExtension();
            }

            public Type getType() {
                String type = dependency.getType();
                return ((TypeRegistry)DefaultProject.this.session.getService(TypeRegistry.class)).getType(type);
            }

            @Nonnull
            public Scope getScope() {
                return Scope.get((String)dependency.getScope());
            }

            public Boolean getOptional() {
                return dependency.isOptional();
            }

            @Nonnull
            public Collection<Exclusion> getExclusions() {
                return new MappedCollection<Exclusion, org.apache.maven.api.model.Exclusion>(dependency.getExclusions(), this::toExclusion);
            }

            private Exclusion toExclusion(final org.apache.maven.api.model.Exclusion exclusion) {
                return new Exclusion(){

                    @Nullable
                    public String getGroupId() {
                        return exclusion.getGroupId();
                    }

                    @Nullable
                    public String getArtifactId() {
                        return exclusion.getArtifactId();
                    }
                };
            }
        };
    }
}

