/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.Node;
import org.apache.maven.api.Project;
import org.apache.maven.api.ResolutionScope;
import org.apache.maven.api.Scope;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.DependencyCollector;
import org.apache.maven.api.services.DependencyCollectorException;
import org.apache.maven.api.services.DependencyCollectorRequest;
import org.apache.maven.api.services.DependencyCollectorResult;
import org.apache.maven.api.services.DependencyResolver;
import org.apache.maven.api.services.DependencyResolverException;
import org.apache.maven.api.services.DependencyResolverRequest;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.internal.impl.AbstractNode;
import org.apache.maven.internal.impl.DefaultProject;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.internal.LifecycleDependencyResolver;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;

@Named
@Singleton
public class DefaultDependencyResolver
implements DependencyResolver {
    public List<Node> flatten(Session s, Node node, ResolutionScope scope) throws DependencyResolverException {
        InternalSession session = InternalSession.from(s);
        DependencyNode root = Utils.cast(AbstractNode.class, node, "node").getDependencyNode();
        List dependencies = session.getRepositorySystem().flattenDependencyNodes(session.getSession(), root, DefaultDependencyResolver.getScopeDependencyFilter(scope));
        dependencies.remove(root);
        return Utils.map(dependencies, session::getNode);
    }

    private static DependencyFilter getScopeDependencyFilter(ResolutionScope scope) {
        Set scopes = scope.scopes().stream().map(Scope::id).collect(Collectors.toSet());
        return (n, p) -> {
            Dependency d = n.getDependency();
            return d == null || scopes.contains(d.getScope());
        };
    }

    public DependencyResolverResult resolve(DependencyResolverRequest request) throws DependencyCollectorException, DependencyResolverException, ArtifactResolverException {
        Utils.nonNull(request, "request can not be null");
        InternalSession session = InternalSession.from(request.getSession());
        if (request.getProject().isPresent()) {
            DependencyResolutionResult result = this.resolveDependencies(request.getSession(), (Project)request.getProject().get(), request.getResolutionScope());
            Map<Dependency, DependencyNode> nodes = this.stream(result.getDependencyGraph()).filter(n -> n.getDependency() != null).collect(Collectors.toMap(DependencyNode::getDependency, n -> n));
            Node root = session.getNode(result.getDependencyGraph());
            ArrayList<Node> dependencies = new ArrayList<Node>();
            LinkedHashMap<org.apache.maven.api.Dependency, Path> artifacts = new LinkedHashMap<org.apache.maven.api.Dependency, Path>();
            ArrayList<Path> paths = new ArrayList<Path>();
            for (Dependency dep : result.getResolvedDependencies()) {
                dependencies.add(session.getNode(nodes.get(dep)));
                Path path = dep.getArtifact().getFile().toPath();
                artifacts.put(session.getDependency(dep), path);
                paths.add(path);
            }
            return new DefaultDependencyResolverResult(result.getCollectionErrors(), root, dependencies, paths, artifacts);
        }
        DependencyCollectorResult collectorResult = ((DependencyCollector)session.getService(DependencyCollector.class)).collect((DependencyCollectorRequest)request);
        List<Node> nodes = this.flatten(session, collectorResult.getRoot(), request.getResolutionScope());
        List deps = nodes.stream().map(Node::getDependency).filter(Objects::nonNull).collect(Collectors.toList());
        List coordinates = deps.stream().map(Artifact::toCoordinate).collect(Collectors.toList());
        Map artifacts = session.resolveArtifacts(coordinates);
        Map<org.apache.maven.api.Dependency, Path> dependencies = deps.stream().collect(Collectors.toMap(d -> d, artifacts::get));
        ArrayList<Path> paths = new ArrayList<Path>(dependencies.values());
        return new DefaultDependencyResolverResult(collectorResult.getExceptions(), collectorResult.getRoot(), nodes, paths, dependencies);
    }

    private Stream<DependencyNode> stream(DependencyNode node) {
        return Stream.concat(Stream.of(node), node.getChildren().stream().flatMap(this::stream));
    }

    private DependencyResolutionResult resolveDependencies(Session session, Project project, ResolutionScope scope) {
        Collection<String> toResolve = this.toScopes(scope);
        try {
            LifecycleDependencyResolver lifecycleDependencyResolver = (LifecycleDependencyResolver)((Lookup)session.getService(Lookup.class)).lookup(LifecycleDependencyResolver.class);
            return lifecycleDependencyResolver.getProjectDependencyResolutionResult(this.getMavenProject(project), toResolve, toResolve, InternalSession.from(session).getMavenSession(), false, Collections.emptySet());
        }
        catch (LifecycleExecutionException e) {
            throw new DependencyResolverException("Unable to resolve project dependencies", (Throwable)e);
        }
    }

    private MavenProject getMavenProject(Project project) {
        return ((DefaultProject)project).getProject();
    }

    private Collection<String> toScopes(ResolutionScope scope) {
        return Utils.map(scope.scopes(), Scope::id);
    }

    static class DefaultDependencyResolverResult
    implements DependencyResolverResult {
        private final List<Exception> exceptions;
        private final Node root;
        private final List<Node> nodes;
        private final List<Path> paths;
        private final Map<org.apache.maven.api.Dependency, Path> dependencies;

        DefaultDependencyResolverResult(List<Exception> exceptions, Node root, List<Node> nodes, List<Path> paths, Map<org.apache.maven.api.Dependency, Path> dependencies) {
            this.exceptions = exceptions;
            this.root = root;
            this.nodes = nodes;
            this.paths = paths;
            this.dependencies = dependencies;
        }

        public List<Exception> getExceptions() {
            return this.exceptions;
        }

        public Node getRoot() {
            return this.root;
        }

        public List<Node> getNodes() {
            return this.nodes;
        }

        public List<Path> getPaths() {
            return this.paths;
        }

        public Map<org.apache.maven.api.Dependency, Path> getDependencies() {
            return this.dependencies;
        }
    }
}

