/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.DependencyProperties;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.internal.impl.Utils;

public class DefaultDependencyProperties
implements DependencyProperties {
    private final Map<String, String> properties;

    public DefaultDependencyProperties(String ... flags) {
        this(Arrays.asList(flags));
    }

    public DefaultDependencyProperties(@Nonnull Collection<String> flags) {
        Utils.nonNull(flags, "flags");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String flag : flags) {
            map.put(flag, Boolean.TRUE.toString());
        }
        this.properties = Collections.unmodifiableMap(map);
    }

    public DefaultDependencyProperties(@Nonnull Map<String, String> properties) {
        this.properties = Collections.unmodifiableMap(Utils.nonNull(properties, "properties"));
    }

    @Nonnull
    public Map<String, String> asMap() {
        return this.properties;
    }

    public boolean checkFlag(@Nonnull String flag) {
        Utils.nonNull(flag, "flag");
        return Boolean.parseBoolean(this.properties.getOrDefault(flag, ""));
    }
}

