/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Collection;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.ArtifactDeployer;
import org.apache.maven.api.services.ArtifactDeployerException;
import org.apache.maven.api.services.ArtifactDeployerRequest;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeployResult;
import org.eclipse.aether.deployment.DeploymentException;

@Named
@Singleton
public class DefaultArtifactDeployer
implements ArtifactDeployer {
    public void deploy(@Nonnull ArtifactDeployerRequest request) {
        Utils.nonNull(request, "request");
        InternalSession session = InternalSession.from(request.getSession());
        Collection artifacts = Utils.nonNull(request.getArtifacts(), "request.artifacts");
        RemoteRepository repository = Utils.nonNull(request.getRepository(), "request.repository");
        try {
            DeployRequest deployRequest = new DeployRequest().setRepository(session.toRepository(repository)).setArtifacts(session.toArtifacts(artifacts));
            DeployResult deployResult = session.getRepositorySystem().deploy(session.getSession(), deployRequest);
        }
        catch (DeploymentException e) {
            throw new ArtifactDeployerException("Unable to deploy artifacts", (Exception)((Object)e));
        }
    }
}

