/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.ArtifactCoordinateFactory;
import org.apache.maven.api.services.ArtifactCoordinateFactoryRequest;
import org.apache.maven.internal.impl.DefaultArtifactCoordinate;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;

@Named
@Singleton
public class DefaultArtifactCoordinateFactory
implements ArtifactCoordinateFactory {
    public ArtifactCoordinate create(@Nonnull ArtifactCoordinateFactoryRequest request) {
        String str1;
        Utils.nonNull(request, "request");
        InternalSession session = InternalSession.from(request.getSession());
        if (request.getCoordinateString() != null) {
            return new DefaultArtifactCoordinate(session, (Artifact)new DefaultArtifact(request.getCoordinateString()));
        }
        ArtifactType type = null;
        if (request.getType() != null) {
            type = session.getSession().getArtifactTypeRegistry().get(request.getType());
        }
        String classifier = (str1 = request.getClassifier()) != null && !str1.isEmpty() ? request.getClassifier() : (type != null ? type.getClassifier() : "");
        String str = request.getExtension();
        String extension = str != null && !str.isEmpty() ? request.getExtension() : (type != null ? type.getExtension() : "");
        return new DefaultArtifactCoordinate(session, (Artifact)new DefaultArtifact(request.getGroupId(), request.getArtifactId(), classifier, extension, request.getVersion(), type));
    }
}

