/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.Listener;
import org.apache.maven.api.LocalRepository;
import org.apache.maven.api.Node;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.ResolutionScope;
import org.apache.maven.api.Session;
import org.apache.maven.api.Version;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.services.ArtifactCoordinateFactory;
import org.apache.maven.api.services.ArtifactDeployer;
import org.apache.maven.api.services.ArtifactFactory;
import org.apache.maven.api.services.ArtifactInstaller;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ArtifactResolver;
import org.apache.maven.api.services.DependencyCollector;
import org.apache.maven.api.services.DependencyCoordinateFactory;
import org.apache.maven.api.services.DependencyResolver;
import org.apache.maven.api.services.LocalRepositoryManager;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.api.services.VersionRangeResolver;
import org.apache.maven.api.services.VersionResolver;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.internal.impl.DefaultArtifact;
import org.apache.maven.internal.impl.DefaultArtifactCoordinate;
import org.apache.maven.internal.impl.DefaultDependency;
import org.apache.maven.internal.impl.DefaultLocalRepository;
import org.apache.maven.internal.impl.DefaultNode;
import org.apache.maven.internal.impl.DefaultProject;
import org.apache.maven.internal.impl.DefaultRemoteRepository;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public abstract class AbstractSession
implements InternalSession {
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final Map<DependencyNode, Node> allNodes = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Artifact, org.apache.maven.api.Artifact> allArtifacts = Collections.synchronizedMap(new WeakHashMap());
    private final Map<org.eclipse.aether.repository.RemoteRepository, RemoteRepository> allRepositories = Collections.synchronizedMap(new WeakHashMap());
    private final Map<String, Project> allProjects = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Dependency, org.apache.maven.api.Dependency> allDependencies = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public RemoteRepository getRemoteRepository(org.eclipse.aether.repository.RemoteRepository repository) {
        return this.allRepositories.computeIfAbsent(repository, DefaultRemoteRepository::new);
    }

    @Override
    public Node getNode(DependencyNode node) {
        return this.getNode(node, false);
    }

    @Override
    public Node getNode(DependencyNode node, boolean verbose) {
        return this.allNodes.computeIfAbsent(node, n -> new DefaultNode(this, (DependencyNode)n, verbose));
    }

    @Override
    @Nonnull
    public org.apache.maven.api.Artifact getArtifact(@Nonnull Artifact artifact) {
        return this.allArtifacts.computeIfAbsent(artifact, a -> new DefaultArtifact(this, (Artifact)a));
    }

    @Override
    @Nonnull
    public org.apache.maven.api.Dependency getDependency(@Nonnull Dependency dependency) {
        return this.allDependencies.computeIfAbsent(dependency, d -> new DefaultDependency(this, (Dependency)d));
    }

    @Override
    public List<Project> getProjects(List<MavenProject> projects) {
        return projects == null ? null : Utils.map(projects, this::getProject);
    }

    @Override
    public Project getProject(MavenProject project) {
        return this.allProjects.computeIfAbsent(project.getId(), id -> new DefaultProject(this, project));
    }

    @Override
    public List<org.eclipse.aether.repository.RemoteRepository> toRepositories(List<RemoteRepository> repositories) {
        return repositories == null ? null : Utils.map(repositories, this::toRepository);
    }

    @Override
    public org.eclipse.aether.repository.RemoteRepository toRepository(RemoteRepository repository) {
        if (repository instanceof DefaultRemoteRepository) {
            return ((DefaultRemoteRepository)repository).getRepository();
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public org.eclipse.aether.repository.LocalRepository toRepository(LocalRepository repository) {
        if (repository instanceof DefaultLocalRepository) {
            return ((DefaultLocalRepository)repository).getRepository();
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public List<ArtifactRepository> toArtifactRepositories(List<RemoteRepository> repositories) {
        return repositories == null ? null : Utils.map(repositories, this::toArtifactRepository);
    }

    @Override
    public abstract ArtifactRepository toArtifactRepository(RemoteRepository var1);

    @Override
    public List<Dependency> toDependencies(Collection<DependencyCoordinate> dependencies) {
        return dependencies == null ? null : Utils.map(dependencies, this::toDependency);
    }

    @Override
    public abstract Dependency toDependency(DependencyCoordinate var1);

    @Override
    public List<Artifact> toArtifacts(Collection<org.apache.maven.api.Artifact> artifacts) {
        return artifacts == null ? null : Utils.map(artifacts, this::toArtifact);
    }

    @Override
    public Artifact toArtifact(org.apache.maven.api.Artifact artifact) {
        Artifact a;
        File file = ((ArtifactManager)this.getService(ArtifactManager.class)).getPath(artifact).map(Path::toFile).orElse(null);
        if (artifact instanceof DefaultArtifact && Objects.equals(file, (a = ((DefaultArtifact)artifact).getArtifact()).getFile())) {
            return a;
        }
        return new org.eclipse.aether.artifact.DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion().toString(), null, file);
    }

    @Override
    public Artifact toArtifact(ArtifactCoordinate coord) {
        if (coord instanceof DefaultArtifactCoordinate) {
            return ((DefaultArtifactCoordinate)coord).getCoordinate();
        }
        return new org.eclipse.aether.artifact.DefaultArtifact(coord.getGroupId(), coord.getArtifactId(), coord.getClassifier(), coord.getExtension(), coord.getVersion().toString(), null, (File)null);
    }

    public void registerListener(@Nonnull Listener listener) {
        this.listeners.add(Utils.nonNull(listener));
    }

    public void unregisterListener(@Nonnull Listener listener) {
        this.listeners.remove(Utils.nonNull(listener));
    }

    @Nonnull
    public Collection<Listener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public LocalRepository createLocalRepository(Path path) {
        return ((RepositoryFactory)this.getService(RepositoryFactory.class)).createLocal(path);
    }

    @Nonnull
    public RemoteRepository createRemoteRepository(@Nonnull String id, @Nonnull String url) {
        return ((RepositoryFactory)this.getService(RepositoryFactory.class)).createRemote(id, url);
    }

    @Nonnull
    public RemoteRepository createRemoteRepository(@Nonnull Repository repository) {
        return ((RepositoryFactory)this.getService(RepositoryFactory.class)).createRemote(repository);
    }

    public ArtifactCoordinate createArtifactCoordinate(String groupId, String artifactId, String version, String extension) {
        return ((ArtifactCoordinateFactory)this.getService(ArtifactCoordinateFactory.class)).create((Session)this, groupId, artifactId, version, extension);
    }

    public ArtifactCoordinate createArtifactCoordinate(String coordString) {
        return ((ArtifactCoordinateFactory)this.getService(ArtifactCoordinateFactory.class)).create((Session)this, coordString);
    }

    public ArtifactCoordinate createArtifactCoordinate(String groupId, String artifactId, String version, String classifier, String extension, String type) {
        return ((ArtifactCoordinateFactory)this.getService(ArtifactCoordinateFactory.class)).create((Session)this, groupId, artifactId, version, classifier, extension, type);
    }

    public ArtifactCoordinate createArtifactCoordinate(org.apache.maven.api.Artifact artifact) {
        return ((ArtifactCoordinateFactory)this.getService(ArtifactCoordinateFactory.class)).create((Session)this, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion().asString(), artifact.getClassifier(), artifact.getExtension(), null);
    }

    public org.apache.maven.api.Artifact createArtifact(String groupId, String artifactId, String version, String extension) {
        return ((ArtifactFactory)this.getService(ArtifactFactory.class)).create((Session)this, groupId, artifactId, version, extension);
    }

    public org.apache.maven.api.Artifact createArtifact(String groupId, String artifactId, String version, String classifier, String extension, String type) {
        return ((ArtifactFactory)this.getService(ArtifactFactory.class)).create((Session)this, groupId, artifactId, version, classifier, extension, type);
    }

    public Map.Entry<org.apache.maven.api.Artifact, Path> resolveArtifact(ArtifactCoordinate coordinate) {
        return ((ArtifactResolver)this.getService(ArtifactResolver.class)).resolve((Session)this, Collections.singletonList(coordinate)).getArtifacts().entrySet().iterator().next();
    }

    public Map<org.apache.maven.api.Artifact, Path> resolveArtifacts(ArtifactCoordinate ... coordinates) {
        return this.resolveArtifacts(Arrays.asList(coordinates));
    }

    public Map<org.apache.maven.api.Artifact, Path> resolveArtifacts(Collection<? extends ArtifactCoordinate> coordinates) {
        return ((ArtifactResolver)this.getService(ArtifactResolver.class)).resolve((Session)this, coordinates).getArtifacts();
    }

    public Map.Entry<org.apache.maven.api.Artifact, Path> resolveArtifact(org.apache.maven.api.Artifact artifact) {
        ArtifactCoordinate coordinate = ((ArtifactCoordinateFactory)this.getService(ArtifactCoordinateFactory.class)).create((Session)this, artifact);
        return this.resolveArtifact(coordinate);
    }

    public Map<org.apache.maven.api.Artifact, Path> resolveArtifacts(org.apache.maven.api.Artifact ... artifacts) {
        ArtifactCoordinateFactory acf = (ArtifactCoordinateFactory)this.getService(ArtifactCoordinateFactory.class);
        List<ArtifactCoordinate> coords = Utils.map(Arrays.asList(artifacts), a -> acf.create((Session)this, a));
        return this.resolveArtifacts(coords);
    }

    public void installArtifacts(org.apache.maven.api.Artifact ... artifacts) {
        this.installArtifacts(Arrays.asList(artifacts));
    }

    public void installArtifacts(Collection<org.apache.maven.api.Artifact> artifacts) {
        ((ArtifactInstaller)this.getService(ArtifactInstaller.class)).install((Session)this, artifacts);
    }

    public void deployArtifact(RemoteRepository repository, org.apache.maven.api.Artifact ... artifacts) {
        ((ArtifactDeployer)this.getService(ArtifactDeployer.class)).deploy((Session)this, repository, Arrays.asList(artifacts));
    }

    public void setArtifactPath(@Nonnull org.apache.maven.api.Artifact artifact, @Nonnull Path path) {
        ((ArtifactManager)this.getService(ArtifactManager.class)).setPath(artifact, path);
    }

    @Nonnull
    public Optional<Path> getArtifactPath(@Nonnull org.apache.maven.api.Artifact artifact) {
        return ((ArtifactManager)this.getService(ArtifactManager.class)).getPath(artifact);
    }

    public boolean isVersionSnapshot(@Nonnull String version) {
        return ((VersionParser)this.getService(VersionParser.class)).isSnapshot(version);
    }

    @Nonnull
    public DependencyCoordinate createDependencyCoordinate(@Nonnull ArtifactCoordinate coordinate) {
        return ((DependencyCoordinateFactory)this.getService(DependencyCoordinateFactory.class)).create((Session)this, coordinate);
    }

    @Nonnull
    public DependencyCoordinate createDependencyCoordinate(@Nonnull org.apache.maven.api.Dependency dependency) {
        return ((DependencyCoordinateFactory)this.getService(DependencyCoordinateFactory.class)).create((Session)this, dependency);
    }

    @Nonnull
    public Node collectDependencies(@Nonnull org.apache.maven.api.Artifact artifact) {
        return ((DependencyCollector)this.getService(DependencyCollector.class)).collect((Session)this, artifact).getRoot();
    }

    @Nonnull
    public Node collectDependencies(@Nonnull Project project) {
        return ((DependencyCollector)this.getService(DependencyCollector.class)).collect((Session)this, project).getRoot();
    }

    @Nonnull
    public Node collectDependencies(@Nonnull DependencyCoordinate dependency) {
        return ((DependencyCollector)this.getService(DependencyCollector.class)).collect((Session)this, dependency).getRoot();
    }

    @Nonnull
    public List<Node> flattenDependencies(@Nonnull Node node, @Nonnull ResolutionScope scope) {
        return ((DependencyResolver)this.getService(DependencyResolver.class)).flatten((Session)this, node, scope);
    }

    public List<Path> resolveDependencies(DependencyCoordinate dependency) {
        return ((DependencyResolver)this.getService(DependencyResolver.class)).resolve((Session)this, dependency).getPaths();
    }

    public List<Path> resolveDependencies(List<DependencyCoordinate> dependencies) {
        return ((DependencyResolver)this.getService(DependencyResolver.class)).resolve((Session)this, dependencies).getPaths();
    }

    public List<Path> resolveDependencies(Project project, ResolutionScope scope) {
        return ((DependencyResolver)this.getService(DependencyResolver.class)).resolve((Session)this, project, scope).getPaths();
    }

    public Path getPathForLocalArtifact(@Nonnull org.apache.maven.api.Artifact artifact) {
        return ((LocalRepositoryManager)this.getService(LocalRepositoryManager.class)).getPathForLocalArtifact((Session)this, this.getLocalRepository(), artifact);
    }

    public Path getPathForRemoteArtifact(RemoteRepository remote, org.apache.maven.api.Artifact artifact) {
        return ((LocalRepositoryManager)this.getService(LocalRepositoryManager.class)).getPathForRemoteArtifact((Session)this, this.getLocalRepository(), remote, artifact);
    }

    public Version parseVersion(String version) {
        return ((VersionParser)this.getService(VersionParser.class)).parseVersion(version);
    }

    public VersionRange parseVersionRange(String versionRange) {
        return ((VersionParser)this.getService(VersionParser.class)).parseVersionRange(versionRange);
    }

    public Version resolveVersion(ArtifactCoordinate artifact) {
        return ((VersionResolver)this.getService(VersionResolver.class)).resolve((Session)this, artifact).getVersion();
    }

    public List<Version> resolveVersionRange(ArtifactCoordinate artifact) {
        return ((VersionRangeResolver)this.getService(VersionRangeResolver.class)).resolve((Session)this, artifact).getVersions();
    }
}

