/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.util.Objects;
import org.apache.maven.api.Type;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.internal.impl.DefaultType;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;

public class TypeRegistryAdapter
implements ArtifactTypeRegistry {
    private final TypeRegistry typeRegistry;

    public TypeRegistryAdapter(TypeRegistry typeRegistry) {
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry");
    }

    public ArtifactType get(String typeId) {
        Type type = this.typeRegistry.getType(typeId);
        if (type instanceof ArtifactType) {
            return (ArtifactType)type;
        }
        if (type != null) {
            return new DefaultType(type.getId(), type.getLanguage(), type.getExtension(), type.getClassifier(), type.getDependencyProperties());
        }
        return null;
    }
}

