/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;
import org.apache.maven.repository.internal.MavenWorkspaceReader;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;

public class MavenChainedWorkspaceReader
implements MavenWorkspaceReader {
    protected List<WorkspaceReader> readers;
    protected WorkspaceRepository repository;

    public MavenChainedWorkspaceReader(WorkspaceReader ... readers) {
        this.setReaders(Arrays.asList(readers));
    }

    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    public Model findModel(Artifact artifact) {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        Model model = null;
        for (WorkspaceReader workspaceReader : this.readers) {
            if (workspaceReader instanceof MavenWorkspaceReader && (model = ((MavenWorkspaceReader)workspaceReader).findModel(artifact)) != null) break;
        }
        return model;
    }

    public File findArtifact(Artifact artifact) {
        WorkspaceReader reader;
        Objects.requireNonNull(artifact, "artifact cannot be null");
        File file = null;
        Iterator<WorkspaceReader> iterator = this.readers.iterator();
        while (iterator.hasNext() && (file = (reader = iterator.next()).findArtifact(artifact)) == null) {
        }
        return file;
    }

    public List<String> findVersions(Artifact artifact) {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        LinkedHashSet versions = new LinkedHashSet();
        for (WorkspaceReader reader : this.readers) {
            versions.addAll(reader.findVersions(artifact));
        }
        return Collections.unmodifiableList(new ArrayList(versions));
    }

    public void setReaders(Collection<WorkspaceReader> readers) {
        this.readers = Collections.unmodifiableList(new ArrayList<WorkspaceReader>(readers));
        Key key = new Key(this.readers);
        this.repository = new WorkspaceRepository(key.getContentType(), (Object)key);
    }

    public List<WorkspaceReader> getReaders() {
        return this.readers;
    }

    public static WorkspaceReader of(Collection<WorkspaceReader> workspaceReaderCollection) {
        WorkspaceReader[] readers = workspaceReaderCollection.toArray(new WorkspaceReader[0]);
        if (readers.length == 1) {
            return readers[0];
        }
        return new MavenChainedWorkspaceReader(readers);
    }

    private static class Key {
        private final List<Object> keys;
        private final String type;

        Key(Collection<WorkspaceReader> readers) {
            this.keys = readers.stream().map(r -> r.getRepository().getKey()).collect(Collectors.toList());
            this.type = readers.stream().map(r -> r.getRepository().getContentType()).collect(Collectors.joining("+"));
        }

        public String getContentType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj != null && this.getClass().equals(obj.getClass()) && this.keys.equals(((Key)obj).keys);
        }

        public int hashCode() {
            return this.keys.hashCode();
        }
    }
}

