/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.services.VersionParserException;
import org.apache.maven.model.version.VersionParser;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;

@Named
@Singleton
public class DefaultModelVersionParser
implements VersionParser {
    private final VersionScheme versionScheme;

    @Inject
    public DefaultModelVersionParser(VersionScheme versionScheme) {
        this.versionScheme = Objects.requireNonNull(versionScheme, "versionScheme");
    }

    public org.apache.maven.api.Version parseVersion(String version) {
        Objects.requireNonNull(version, "version");
        return new DefaultVersion(this.versionScheme, version);
    }

    public VersionRange parseVersionRange(String range) {
        Objects.requireNonNull(range, "range");
        return new DefaultVersionRange(this.versionScheme, range);
    }

    static class DefaultVersion
    implements org.apache.maven.api.Version {
        private final VersionScheme versionScheme;
        private final Version delegate;

        DefaultVersion(VersionScheme versionScheme, String delegateValue) {
            this.versionScheme = versionScheme;
            try {
                this.delegate = versionScheme.parseVersion(delegateValue);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new VersionParserException("Unable to parse version: " + delegateValue, (Exception)((Object)e));
            }
        }

        public int compareTo(org.apache.maven.api.Version o) {
            if (o instanceof DefaultVersion) {
                return this.delegate.compareTo((Object)((DefaultVersion)o).delegate);
            }
            return this.compareTo(new DefaultVersion(this.versionScheme, o.asString()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultVersion that = (DefaultVersion)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }

        public String asString() {
            return this.delegate.toString();
        }

        public String toString() {
            return this.asString();
        }
    }

    static class DefaultVersionRange
    implements VersionRange {
        private final VersionScheme versionScheme;
        private final org.eclipse.aether.version.VersionRange delegate;

        DefaultVersionRange(VersionScheme versionScheme, String delegateValue) {
            this.versionScheme = versionScheme;
            try {
                this.delegate = versionScheme.parseVersionRange(delegateValue);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new VersionParserException("Unable to parse version range: " + delegateValue, (Exception)((Object)e));
            }
        }

        public boolean contains(org.apache.maven.api.Version version) {
            if (version instanceof DefaultVersion) {
                return this.delegate.containsVersion(((DefaultVersion)version).delegate);
            }
            return this.contains(new DefaultVersion(this.versionScheme, version.asString()));
        }

        public String asString() {
            return this.delegate.toString();
        }

        public String toString() {
            return this.asString();
        }
    }
}

