/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.DefaultModelProblemCollector;
import org.apache.maven.model.building.DefaultTransformerContext;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.Graph;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.TransformerContext;
import org.apache.maven.model.building.TransformerContextBuilder;

class DefaultTransformerContextBuilder
implements TransformerContextBuilder {
    private final Graph dag = new Graph();
    private final DefaultModelBuilder defaultModelBuilder;
    private final DefaultTransformerContext context;
    private final Map<String, Set<FileModelSource>> mappedSources = new ConcurrentHashMap<String, Set<FileModelSource>>(64);

    DefaultTransformerContextBuilder(DefaultModelBuilder defaultModelBuilder) {
        this.defaultModelBuilder = defaultModelBuilder;
        this.context = new DefaultTransformerContext(defaultModelBuilder.getModelProcessor());
    }

    @Override
    public TransformerContext initialize(final ModelBuildingRequest request, ModelProblemCollector collector) {
        final DefaultModelProblemCollector problems = (DefaultModelProblemCollector)collector;
        return new TransformerContext(){
            private volatile boolean fullReactorLoaded;

            @Override
            public Path locate(Path path) {
                return DefaultTransformerContextBuilder.this.context.locate(path);
            }

            @Override
            public String getUserProperty(String key) {
                return ((DefaultTransformerContextBuilder)DefaultTransformerContextBuilder.this).context.userProperties.computeIfAbsent(key, k -> request.getUserProperties().getProperty(key));
            }

            @Override
            public Model getRawModel(Path from, String gId, String aId) {
                Model model = this.findRawModel(from, gId, aId);
                if (model != null) {
                    ((DefaultTransformerContextBuilder)DefaultTransformerContextBuilder.this).context.modelByGA.put(new DefaultTransformerContext.GAKey(gId, aId), new DefaultTransformerContext.Holder(model));
                    ((DefaultTransformerContextBuilder)DefaultTransformerContextBuilder.this).context.modelByPath.put(model.getPomFile().toPath(), new DefaultTransformerContext.Holder(model));
                }
                return model;
            }

            @Override
            public Model getRawModel(Path from, Path path) {
                Model model = this.findRawModel(from, path);
                if (model != null) {
                    String groupId = DefaultTransformerContextBuilder.this.defaultModelBuilder.getGroupId(model);
                    ((DefaultTransformerContextBuilder)DefaultTransformerContextBuilder.this).context.modelByGA.put(new DefaultTransformerContext.GAKey(groupId, model.getArtifactId()), new DefaultTransformerContext.Holder(model));
                    ((DefaultTransformerContextBuilder)DefaultTransformerContextBuilder.this).context.modelByPath.put(path, new DefaultTransformerContext.Holder(model));
                }
                return model;
            }

            private Model findRawModel(Path from, String groupId, String artifactId) {
                FileModelSource source = DefaultTransformerContextBuilder.this.getSource(groupId, artifactId);
                if (source == null) {
                    this.loadFullReactor();
                    source = DefaultTransformerContextBuilder.this.getSource(groupId, artifactId);
                }
                if (source != null) {
                    if (!DefaultTransformerContextBuilder.this.addEdge(from, source.getFile().toPath(), problems)) {
                        return null;
                    }
                    try {
                        DefaultModelBuildingRequest gaBuildingRequest = new DefaultModelBuildingRequest(request).setModelSource(source);
                        return DefaultTransformerContextBuilder.this.defaultModelBuilder.readRawModel(gaBuildingRequest, problems);
                    }
                    catch (ModelBuildingException modelBuildingException) {
                        // empty catch block
                    }
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void loadFullReactor() {
                if (!this.fullReactorLoaded) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.fullReactorLoaded) {
                            this.doLoadFullReactor();
                            this.fullReactorLoaded = true;
                        }
                    }
                }
            }

            private void doLoadFullReactor() {
                Path rootDirectory = request.getRootDirectory();
                if (rootDirectory == null) {
                    return;
                }
                ArrayList<File> toLoad = new ArrayList<File>();
                File root = DefaultTransformerContextBuilder.this.defaultModelBuilder.getModelProcessor().locateExistingPom(rootDirectory.toFile());
                toLoad.add(root);
                while (!toLoad.isEmpty()) {
                    File pom = (File)toLoad.remove(0);
                    try {
                        DefaultModelBuildingRequest gaBuildingRequest = new DefaultModelBuildingRequest(request).setModelSource(new FileModelSource(pom));
                        Model rawModel = DefaultTransformerContextBuilder.this.defaultModelBuilder.readFileModel(gaBuildingRequest, problems);
                        for (String module : rawModel.getModules()) {
                            File moduleFile = DefaultTransformerContextBuilder.this.defaultModelBuilder.getModelProcessor().locateExistingPom(new File(pom.getParent(), module));
                            if (moduleFile == null) continue;
                            toLoad.add(moduleFile);
                        }
                    }
                    catch (ModelBuildingException modelBuildingException) {
                    }
                }
            }

            private Model findRawModel(Path from, Path p) {
                if (!Files.isRegularFile(p, new LinkOption[0])) {
                    throw new IllegalArgumentException("Not a regular file: " + p);
                }
                if (!DefaultTransformerContextBuilder.this.addEdge(from, p, problems)) {
                    return null;
                }
                DefaultModelBuildingRequest req = new DefaultModelBuildingRequest(request).setPomFile(p.toFile()).setModelSource(new FileModelSource(p.toFile()));
                try {
                    return DefaultTransformerContextBuilder.this.defaultModelBuilder.readRawModel(req, problems);
                }
                catch (ModelBuildingException modelBuildingException) {
                    return null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addEdge(Path from, Path p, DefaultModelProblemCollector problems) {
        try {
            Graph graph = this.dag;
            synchronized (graph) {
                this.dag.addEdge(this.dag.addVertex(from.toString()), this.dag.addVertex(p.toString()));
            }
            return true;
        }
        catch (Graph.CycleDetectedException e) {
            problems.add(new DefaultModelProblem("Cycle detected between models at " + from + " and " + p, ModelProblem.Severity.FATAL, null, null, 0, 0, null, e));
            return false;
        }
    }

    @Override
    public TransformerContext build() {
        return this.context;
    }

    public FileModelSource getSource(String groupId, String artifactId) {
        Set<FileModelSource> sources = this.mappedSources.get(groupId + ":" + artifactId);
        if (sources == null) {
            return null;
        }
        return sources.stream().reduce((a, b) -> {
            throw new IllegalStateException(String.format("No unique Source for %s:%s: %s and %s", groupId, artifactId, a.getLocation(), b.getLocation()));
        }).orElse(null);
    }

    public void putSource(String groupId, String artifactId, FileModelSource source) {
        this.mappedSources.computeIfAbsent(groupId + ":" + artifactId, k -> new HashSet()).add(source);
    }
}

