/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;

@Experimental
abstract class BaseRequest {
    private final Session session;

    protected BaseRequest(@Nonnull Session session) {
        this.session = BaseRequest.nonNull(session, "session cannot be null");
    }

    @Nonnull
    public Session getSession() {
        return this.session;
    }

    public static <T> T nonNull(T obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    protected static <T> Collection<T> unmodifiable(Collection<T> obj) {
        return obj != null && !obj.isEmpty() ? Collections.unmodifiableCollection(new ArrayList<T>(obj)) : Collections.emptyList();
    }
}

