/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.fuzzyml;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.manifoldcf.core.fuzzyml.XMLFuzzyHierarchicalParseState;
import org.apache.manifoldcf.core.fuzzyml.XMLWriterParsingContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class XMLOutputStreamParsingContext
extends XMLWriterParsingContext {
    protected OutputStream outputStream;

    public XMLOutputStreamParsingContext(XMLFuzzyHierarchicalParseState theStream, String namespace, String localname, String qname, Map<String, String> theseAttributes, OutputStream os) throws ManifoldCFException {
        super(theStream, namespace, localname, qname, theseAttributes, new OutputStreamWriter(os, StandardCharsets.UTF_8));
        this.outputStream = os;
    }

    @Override
    public void flush() throws ManifoldCFException {
        try {
            if (this.outputStream != null) {
                super.flush();
                this.outputStream.flush();
            }
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), e);
        }
    }

    public void close() throws ManifoldCFException {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), e);
        }
    }
}

