/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
@Metrics(about="Aggregate RetryCache metrics", context="rpc")
public class RetryCacheMetrics {
    static final Log LOG = LogFactory.getLog(RetryCacheMetrics.class);
    final MetricsRegistry registry;
    final String name;
    @Metric(value={"Number of RetryCache hit"})
    MutableCounterLong cacheHit;
    @Metric(value={"Number of RetryCache cleared"})
    MutableCounterLong cacheCleared;
    @Metric(value={"Number of RetryCache updated"})
    MutableCounterLong cacheUpdated;

    RetryCacheMetrics(RetryCache retryCache) {
        this.name = "RetryCache." + retryCache.getCacheName();
        this.registry = new MetricsRegistry(this.name);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initialized " + this.registry));
        }
    }

    public String getName() {
        return this.name;
    }

    public static RetryCacheMetrics create(RetryCache cache) {
        RetryCacheMetrics m = new RetryCacheMetrics(cache);
        return DefaultMetricsSystem.instance().register(m.name, null, m);
    }

    public void incrCacheHit() {
        this.cacheHit.incr();
    }

    public void incrCacheCleared() {
        this.cacheCleared.incr();
    }

    public void incrCacheUpdated() {
        this.cacheUpdated.incr();
    }

    public long getCacheHit() {
        return this.cacheHit.value();
    }

    public long getCacheCleared() {
        return this.cacheCleared.value();
    }

    public long getCacheUpdated() {
        return this.cacheUpdated.value();
    }
}

