/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.ULogger;
import org.apache.log4j.helpers.MessageFormatter;

public final class Log4JULogger
implements ULogger {
    private final Logger logger;

    public Log4JULogger(Logger l) {
        if (l == null) {
            throw new NullPointerException("l");
        }
        this.logger = l;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(Object msg) {
        this.logger.debug(msg);
    }

    @Override
    public void debug(Object parameterizedMsg, Object param1) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormatter.format(parameterizedMsg.toString(), param1));
        }
    }

    @Override
    public void debug(String parameterizedMsg, Object param1, Object param2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormatter.format(parameterizedMsg.toString(), param1, param2));
        }
    }

    @Override
    public void debug(Object msg, Throwable t) {
        this.logger.debug(msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(Object msg) {
        this.logger.info(msg);
    }

    @Override
    public void info(Object parameterizedMsg, Object param1) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(MessageFormatter.format(parameterizedMsg.toString(), param1));
        }
    }

    @Override
    public void info(String parameterizedMsg, Object param1, Object param2) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(MessageFormatter.format(parameterizedMsg.toString(), param1, param2));
        }
    }

    @Override
    public void info(Object msg, Throwable t) {
        this.logger.info(msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor(Level.WARN);
    }

    @Override
    public void warn(Object msg) {
        this.logger.warn(msg);
    }

    @Override
    public void warn(Object parameterizedMsg, Object param1) {
        if (this.logger.isEnabledFor(Level.WARN)) {
            this.logger.warn(MessageFormatter.format(parameterizedMsg.toString(), param1));
        }
    }

    @Override
    public void warn(String parameterizedMsg, Object param1, Object param2) {
        if (this.logger.isEnabledFor(Level.WARN)) {
            this.logger.warn(MessageFormatter.format(parameterizedMsg.toString(), param1, param2));
        }
    }

    @Override
    public void warn(Object msg, Throwable t) {
        this.logger.warn(msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor(Level.ERROR);
    }

    @Override
    public void error(Object msg) {
        this.logger.error(msg);
    }

    @Override
    public void error(Object parameterizedMsg, Object param1) {
        if (this.logger.isEnabledFor(Level.ERROR)) {
            this.logger.error(MessageFormatter.format(parameterizedMsg.toString(), param1));
        }
    }

    @Override
    public void error(String parameterizedMsg, Object param1, Object param2) {
        if (this.logger.isEnabledFor(Level.ERROR)) {
            this.logger.error(MessageFormatter.format(parameterizedMsg.toString(), param1, param2));
        }
    }

    @Override
    public void error(Object msg, Throwable t) {
        this.logger.error(msg, t);
    }
}

