/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.db.ConnectionSourceSkeleton;

public class JNDIConnectionSource
extends ConnectionSourceSkeleton {
    private String jndiLocation = null;
    private DataSource dataSource = null;

    @Override
    public void activateOptions() {
        if (this.jndiLocation == null) {
            this.getLogger().error("No JNDI location specified for JNDIConnectionSource.");
        }
        this.discoverConnnectionProperties();
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = null;
        try {
            if (this.dataSource == null) {
                this.dataSource = this.lookupDataSource();
            }
            conn = this.getUser() == null ? this.dataSource.getConnection() : this.dataSource.getConnection(this.getUser(), this.getPassword());
        }
        catch (NamingException ne) {
            this.getLogger().error((Object)"Error while getting data source", ne);
            throw new SQLException("NamingException while looking up DataSource: " + ne.getMessage());
        }
        catch (ClassCastException cce) {
            this.getLogger().error((Object)"ClassCastException while looking up DataSource.", cce);
            throw new SQLException("ClassCastException while looking up DataSource: " + cce.getMessage());
        }
        return conn;
    }

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    public void setJndiLocation(String jndiLocation) {
        this.jndiLocation = jndiLocation;
    }

    private DataSource lookupDataSource() throws NamingException, SQLException {
        InitialContext ctx = new InitialContext();
        Object obj = ctx.lookup(this.jndiLocation);
        DataSource ds = (DataSource)obj;
        if (ds == null) {
            throw new SQLException("Failed to obtain data source from JNDI location " + this.jndiLocation);
        }
        return ds;
    }
}

