/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.Attributes;
import io.grpc.CallCredentials;
import io.grpc.ChannelCredentials;
import io.grpc.ChannelLogger;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.internal.ConnectionClientTransport;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.apache.kyuubi.shade.com.google.common.base.Objects;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;

public interface ClientTransportFactory
extends Closeable {
    public ConnectionClientTransport newClientTransport(SocketAddress var1, ClientTransportOptions var2, ChannelLogger var3);

    public ScheduledExecutorService getScheduledExecutorService();

    @CheckReturnValue
    @Nullable
    public SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials var1);

    @Override
    public void close();

    public static final class SwapChannelCredentialsResult {
        final ClientTransportFactory transportFactory;
        @Nullable
        final CallCredentials callCredentials;

        public SwapChannelCredentialsResult(ClientTransportFactory transportFactory, @Nullable CallCredentials callCredentials) {
            this.transportFactory = Preconditions.checkNotNull(transportFactory, "transportFactory");
            this.callCredentials = callCredentials;
        }
    }

    public static final class ClientTransportOptions {
        private ChannelLogger channelLogger;
        private String authority = "unknown-authority";
        private Attributes eagAttributes = Attributes.EMPTY;
        @Nullable
        private String userAgent;
        @Nullable
        private HttpConnectProxiedSocketAddress connectProxiedSocketAddr;

        public ChannelLogger getChannelLogger() {
            return this.channelLogger;
        }

        public ClientTransportOptions setChannelLogger(ChannelLogger channelLogger) {
            this.channelLogger = channelLogger;
            return this;
        }

        public String getAuthority() {
            return this.authority;
        }

        public ClientTransportOptions setAuthority(String authority) {
            this.authority = Preconditions.checkNotNull(authority, "authority");
            return this;
        }

        public Attributes getEagAttributes() {
            return this.eagAttributes;
        }

        public ClientTransportOptions setEagAttributes(Attributes eagAttributes) {
            Preconditions.checkNotNull(eagAttributes, "eagAttributes");
            this.eagAttributes = eagAttributes;
            return this;
        }

        @Nullable
        public String getUserAgent() {
            return this.userAgent;
        }

        public ClientTransportOptions setUserAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Nullable
        public HttpConnectProxiedSocketAddress getHttpConnectProxiedSocketAddress() {
            return this.connectProxiedSocketAddr;
        }

        public ClientTransportOptions setHttpConnectProxiedSocketAddress(@Nullable HttpConnectProxiedSocketAddress connectProxiedSocketAddr) {
            this.connectProxiedSocketAddr = connectProxiedSocketAddr;
            return this;
        }

        public int hashCode() {
            return Objects.hashCode(this.authority, this.eagAttributes, this.userAgent, this.connectProxiedSocketAddr);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClientTransportOptions)) {
                return false;
            }
            ClientTransportOptions that = (ClientTransportOptions)o;
            return this.authority.equals(that.authority) && this.eagAttributes.equals(that.eagAttributes) && Objects.equal(this.userAgent, that.userAgent) && Objects.equal(this.connectProxiedSocketAddr, that.connectProxiedSocketAddr);
        }
    }
}

