/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink.operation;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.client.gateway.ResultDescriptor;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.command.AddJarOperation;
import org.apache.flink.table.operations.command.RemoveJarOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.operations.command.ShowJarsOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.kyuubi.engine.flink.FlinkEngineUtils$;
import org.apache.kyuubi.engine.flink.operation.FlinkOperation;
import org.apache.kyuubi.engine.flink.operation.OperationUtils$;
import org.apache.kyuubi.engine.flink.result.ResultSet;
import org.apache.kyuubi.engine.flink.schema.RowSet$;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.reflection.DynMethods;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.util.RowSetUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001\u0002\r\u001a\u0001\u0019B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tk\u0001\u0011)\u0019!C!m!AA\t\u0001B\u0001B\u0003%q\u0007\u0003\u0005F\u0001\t\u0015\r\u0011\"\u0011G\u0011!Y\u0005A!A!\u0002\u00139\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011A\u0003!\u0011!Q\u0001\nECQ\u0001\u0016\u0001\u0005\u0002UCq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004f\u0001\u0001\u0006IA\u0018\u0005\bM\u0002\u0001\r\u0011\"\u0001h\u0011\u001d!\b\u00011A\u0005\u0002UDaa\u001f\u0001!B\u0013A\u0007\"\u0002?\u0001\t\u0003j\bBB@\u0001\t#\n\t\u0001C\u0004\u0002\u0004\u0001!\t&!\u0001\t\u000f\u0005\u0015\u0001\u0001\"\u0015\u0002\u0002!9\u0011q\u0001\u0001\u0005\n\u0005\u0005\u0001bBA\u0005\u0001\u0011%\u00111\u0002\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\tY\u0003\u0001C\u0005\u0003[A\u0001\"a\r\u0001A\u0013%\u0011Q\u0007\u0005\t\u0003g\u0002\u0001\u0015\"\u0003\u0002v\t\u0001R\t_3dkR,7\u000b^1uK6,g\u000e\u001e\u0006\u00035m\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\u000b\u0005qi\u0012!\u00024mS:\\'B\u0001\u0010 \u0003\u0019)gnZ5oK*\u0011\u0001%I\u0001\u0007Wf,XOY5\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\r\u0001qe\u000b\t\u0003Q%j\u0011!G\u0005\u0003Ue\u0011aB\u00127j].|\u0005/\u001a:bi&|g\u000e\u0005\u0002-[5\tq$\u0003\u0002/?\t9Aj\\4hS:<\u0017aB:fgNLwN\u001c\t\u0003cMj\u0011A\r\u0006\u0003_}I!\u0001\u000e\u001a\u0003\u000fM+7o]5p]\u0006I1\u000f^1uK6,g\u000e^\u000b\u0002oA\u0011\u0001(\u0011\b\u0003s}\u0002\"AO\u001f\u000e\u0003mR!\u0001P\u0013\u0002\rq\u0012xn\u001c;?\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001k\u0014AC:uCR,W.\u001a8uA\u0005q1\u000f[8vY\u0012\u0014VO\\!ts:\u001cW#A$\u0011\u0005!KU\"A\u001f\n\u0005)k$a\u0002\"p_2,\u0017M\\\u0001\u0010g\"|W\u000f\u001c3Sk:\f5/\u001f8dA\u0005a\u0011/^3ssRKW.Z8viB\u0011\u0001JT\u0005\u0003\u001fv\u0012A\u0001T8oO\u0006i!/Z:vYRl\u0015\r\u001f*poN\u0004\"\u0001\u0013*\n\u0005Mk$aA%oi\u00061A(\u001b8jiz\"bAV,Y3j[\u0006C\u0001\u0015\u0001\u0011\u0015y\u0003\u00021\u00011\u0011\u0015)\u0004\u00021\u00018\u0011\u0015)\u0005\u00021\u0001H\u0011\u0015a\u0005\u00021\u0001N\u0011\u0015\u0001\u0006\u00021\u0001R\u00031y\u0007/\u001a:bi&|g\u000eT8h+\u0005q\u0006CA0d\u001b\u0005\u0001'BA1c\u0003\rawn\u001a\u0006\u00035}I!\u0001\u001a1\u0003\u0019=\u0003XM]1uS>tGj\\4\u0002\u001b=\u0004XM]1uS>tGj\\4!\u0003\u0015QwNY%e+\u0005A\u0007c\u0001%jW&\u0011!.\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00051\u0014X\"A7\u000b\u00059|\u0017AB2p[6|gN\u0003\u0002qc\u0006\u0019\u0011\r]5\u000b\u0005q\t\u0013BA:n\u0005\u0015QuNY%E\u0003%QwNY%e?\u0012*\u0017\u000f\u0006\u0002wsB\u0011\u0001j^\u0005\u0003qv\u0012A!\u00168ji\"9!\u0010DA\u0001\u0002\u0004A\u0017a\u0001=%c\u00051!n\u001c2JI\u0002\nqbZ3u\u001fB,'/\u0019;j_:dunZ\u000b\u0002}B\u0019\u0001*\u001b0\u0002\u0013\t,gm\u001c:f%VtG#\u0001<\u0002\u0011\u00054G/\u001a:Sk:\f1B];o\u0013:$XM\u001d8bY\u0006\u0001R\r_3dkR,7\u000b^1uK6,g\u000e^\u0001\u0012eVt\u0017+^3ss>\u0003XM]1uS>tGc\u0001<\u0002\u000e!1!d\u0005a\u0001\u0003\u001f\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0006pa\u0016\u0014\u0018\r^5p]NT1!!\u0007r\u0003\u0015!\u0018M\u00197f\u0013\u0011\ti\"a\u0005\u0003\u001dE+XM]=Pa\u0016\u0014\u0018\r^5p]\u0006a!/\u001e8Pa\u0016\u0014\u0018\r^5p]R\u0019a/a\t\t\ri!\u0002\u0019AA\u0013!\u0011\t\t\"a\n\n\t\u0005%\u00121\u0003\u0002\n\u001fB,'/\u0019;j_:\f!c\u00197fC:,\b/U;fef\u0014Vm];miR\u0019a/a\f\t\r\u0005ER\u00031\u00018\u0003!\u0011Xm];mi&#\u0017\u0001D2p]Z,'\u000f\u001e+p%><HCBA\u001c\u0003\u0007\n\u0019\u0006\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti$]\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u0003\nYDA\u0002S_^Dq!!\u0012\u0017\u0001\u0004\t9%A\u0001s!\u0011\tI%a\u0014\u000e\u0005\u0005-#\u0002BA'\u0003/\tA\u0001Z1uC&!\u0011\u0011KA&\u0005\u001d\u0011vn\u001e#bi\u0006Dq!!\u0016\u0017\u0001\u0004\t9&A\u0005eCR\fG+\u001f9fgB1\u0011\u0011LA2\u0003SrA!a\u0017\u0002`9\u0019!(!\u0018\n\u0003yJ1!!\u0019>\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001a\u0002h\t!A*[:u\u0015\r\t\t'\u0010\t\u0005\u0003W\ny'\u0004\u0002\u0002n)!\u0011QHA\f\u0013\u0011\t\t(!\u001c\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fq\u0001^8BeJ\f\u0017\u0010\u0006\u0005\u0002x\u0005\u0015\u0016QWA]!\u001dA\u0015\u0011PA?\u00037K1!a\u001f>\u0005\u0019!V\u000f\u001d7feA\"\u0011qPAE!\u0015A\u0015\u0011QAC\u0013\r\t\u0019)\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u000f\u000bI\t\u0004\u0001\u0005\u0017\u0005-u#!A\u0001\u0002\u000b\u0005\u0011Q\u0012\u0002\u0004?\u0012\n\u0014\u0003BAH\u0003+\u00032\u0001SAI\u0013\r\t\u0019*\u0010\u0002\b\u001d>$\b.\u001b8h!\rA\u0015qS\u0005\u0004\u00033k$aA!osB\"\u0011QTAQ!\u0015A\u0015\u0011QAP!\u0011\t9)!)\u0005\u0017\u0005\rv#!A\u0001\u0002\u000b\u0005\u0011Q\u0012\u0002\u0004?\u0012\u0012\u0004bBAT/\u0001\u0007\u0011\u0011V\u0001\bW\u0016LH+\u001f9f!\u0011\tY+!-\u000e\u0005\u00055&\u0002BAX\u0003[\nq\u0001\\8hS\u000e\fG.\u0003\u0003\u00024\u00065&a\u0003'pO&\u001c\u0017\r\u001c+za\u0016Dq!a.\u0018\u0001\u0004\tI+A\u0005wC2,X\rV=qK\"9\u00111X\fA\u0002\u0005u\u0016!C1se\u0006LH)\u0019;b!\u0011\ty,!2\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u0017\naAY5oCJL\u0018\u0002BAd\u0003\u0003\u0014QBQ5oCJLX*\u00199ECR\f\u0007")
public class ExecuteStatement
extends FlinkOperation {
    private final String statement;
    private final boolean shouldRunAsync;
    private final long queryTimeout;
    private final int resultMaxRows;
    private final OperationLog operationLog;
    private Option<JobID> jobId;

    @Override
    public String statement() {
        return this.statement;
    }

    @Override
    public boolean shouldRunAsync() {
        return this.shouldRunAsync;
    }

    private OperationLog operationLog() {
        return this.operationLog;
    }

    public Option<JobID> jobId() {
        return this.jobId;
    }

    public void jobId_$eq(Option<JobID> x$1) {
        this.jobId = x$1;
    }

    @Override
    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this.operationLog());
    }

    @Override
    public void beforeRun() {
        OperationLog$.MODULE$.setCurrentOperationLog(this.operationLog());
        this.setState(OperationState$.MODULE$.PENDING());
        this.setHasResultSet(true);
    }

    @Override
    public void afterRun() {
        OperationLog$.MODULE$.removeCurrentOperationLog();
    }

    @Override
    public void runInternal() {
        this.addTimeoutMonitor(this.queryTimeout);
        this.executeStatement();
    }

    private void executeStatement() {
        block20: {
            try {
                try {
                    Operation operation;
                    this.setState(OperationState$.MODULE$.RUNNING());
                    Operation operation2 = operation = this.executor().parseStatement(this.sessionId(), this.statement());
                    if (operation2 instanceof QueryOperation) {
                        QueryOperation queryOperation = (QueryOperation)operation2;
                        this.runQueryOperation(queryOperation);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (operation2 instanceof SetOperation) {
                        SetOperation setOperation = (SetOperation)operation2;
                        this.resultSet_$eq(OperationUtils$.MODULE$.runSetOperation(setOperation, this.executor(), this.sessionId()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (operation2 instanceof ResetOperation) {
                        ResetOperation resetOperation = (ResetOperation)operation2;
                        this.resultSet_$eq(OperationUtils$.MODULE$.runResetOperation(resetOperation, this.executor(), this.sessionId()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (operation2 instanceof AddJarOperation) {
                        AddJarOperation addJarOperation = (AddJarOperation)operation2;
                        this.resultSet_$eq(OperationUtils$.MODULE$.runAddJarOperation(addJarOperation, this.executor(), this.sessionId()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (operation2 instanceof RemoveJarOperation) {
                        RemoveJarOperation removeJarOperation = (RemoveJarOperation)operation2;
                        this.resultSet_$eq(OperationUtils$.MODULE$.runRemoveJarOperation(removeJarOperation, this.executor(), this.sessionId()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (operation2 instanceof ShowJarsOperation) {
                        ShowJarsOperation showJarsOperation = (ShowJarsOperation)operation2;
                        this.resultSet_$eq(OperationUtils$.MODULE$.runShowJarOperation(showJarsOperation, this.executor(), this.sessionId()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (operation2 != null) {
                        Operation operation3 = operation2;
                        this.runOperation(operation3);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)operation2);
                    }
                    this.setState(OperationState$.MODULE$.FINISHED());
                }
                catch (Throwable x$1) {
                    PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(true);
                    if (catchExpr$1.isDefinedAt((Object)x$1)) {
                        catchExpr$1.apply((Object)x$1);
                        break block20;
                    }
                    throw x$1;
                }
            }
            finally {
                this.shutdownTimeoutMonitor();
            }
        }
    }

    private void runQueryOperation(QueryOperation operation) {
        ObjectRef resultId = ObjectRef.create(null);
        try {
            ResultDescriptor resultDescriptor = this.executor().executeQuery(this.sessionId(), operation);
            List dataTypes = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(resultDescriptor.getResultSchema().getColumnDataTypes()).asScala()).toList();
            resultId.elem = resultDescriptor.getResultId();
            ArrayBuffer rows = new ArrayBuffer();
            BooleanRef loop = BooleanRef.create((boolean)true);
            while (loop.elem) {
                BoxedUnit boxedUnit;
                Thread.sleep(50L);
                int pageSize = Math.min(500, this.resultMaxRows);
                TypedResult result = this.executor().snapshotResult(this.sessionId(), (String)resultId.elem, pageSize);
                TypedResult.ResultType resultType = result.getType();
                if (TypedResult.ResultType.PAYLOAD.equals(resultType)) {
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), Predef$.MODULE$.Integer2int((Integer)result.getPayload())).foreach((Function1 & Serializable & scala.Serializable)page -> ExecuteStatement.$anonfun$runQueryOperation$1(this, rows, resultId, dataTypes, loop, BoxesRunTime.unboxToInt((Object)page)));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (TypedResult.ResultType.EOS.equals(resultType)) {
                    loop.elem = false;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (TypedResult.ResultType.EMPTY.equals(resultType)) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)resultType);
            }
            this.resultSet_$eq(ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(resultDescriptor.getResultSchema().getColumns()).data((Row[])((TraversableOnce)rows.slice(0, this.resultMaxRows)).toArray(ClassTag$.MODULE$.apply(Row.class))).build());
        }
        finally {
            if ((String)resultId.elem != null) {
                this.cleanupQueryResult((String)resultId.elem);
            }
        }
    }

    private void runOperation(Operation operation) {
        DynMethods.BoundMethod executeOperation = DynMethods.builder("executeOperation").impl(this.executor().getClass(), String.class, Operation.class).build(this.executor());
        TableResult result = (TableResult)executeOperation.invoke(this.sessionId(), operation);
        this.jobId_$eq((Option<JobID>)this.RichOptional(result.getJobClient()).asScala().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getJobID()));
        result.await();
        this.resultSet_$eq(ResultSet.fromTableResult(result));
    }

    private void cleanupQueryResult(String resultId) {
        try {
            this.executor().cancelQuery(this.sessionId(), resultId);
        }
        catch (Throwable t) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Failed to clean result set ").append(resultId).append(" in session ").append(this.sessionId()).toString(), t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Row convertToRow(RowData r, List<DataType> dataTypes) {
        void var3_3;
        Row row = Row.withPositions((RowKind)r.getRowKind(), (int)r.getArity());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), r.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i2 -> {
            DataType dataType = (DataType)dataTypes.apply(i2);
            LogicalType logicalType = dataType.getLogicalType();
            if (logicalType instanceof ArrayType) {
                ArrayData arrayData;
                ArrayType arrayType = (ArrayType)logicalType;
                ArrayData arrayData2 = r.getArray(i2);
                if (arrayData2 == null) {
                    row.setField(i2, null);
                }
                if ((arrayData = arrayData2) instanceof GenericArrayData) {
                    GenericArrayData genericArrayData = (GenericArrayData)arrayData;
                    row.setField(i2, (Object)genericArrayData.toObjectArray());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (arrayData instanceof BinaryArrayData) {
                    BinaryArrayData binaryArrayData = (BinaryArrayData)arrayData;
                    row.setField(i2, (Object)binaryArrayData.toObjectArray(arrayType.getElementType()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (logicalType instanceof BinaryType) {
                row.setField(i2, (Object)r.getBinary(i2));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (logicalType instanceof BigIntType) {
                row.setField(i2, (Object)BoxesRunTime.boxToLong((long)r.getLong(i2)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (logicalType instanceof BooleanType) {
                row.setField(i2, (Object)BoxesRunTime.boxToBoolean((boolean)r.getBoolean(i2)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl = logicalType instanceof VarCharType ? true : logicalType instanceof CharType;
                if (bl) {
                    row.setField(i2, (Object)r.getString(i2));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (logicalType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)logicalType;
                    row.setField(i2, (Object)r.getDecimal(i2, decimalType.getPrecision(), decimalType.getScale()).toBigDecimal());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (logicalType instanceof DateType) {
                    String date = RowSetUtils$.MODULE$.formatLocalDate(LocalDate.ofEpochDay(r.getInt(i2)));
                    row.setField(i2, (Object)date);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (logicalType instanceof TimestampType) {
                    TimestampType timestampType = (TimestampType)logicalType;
                    String ts = RowSetUtils$.MODULE$.formatLocalDateTime(r.getTimestamp(i2, timestampType.getPrecision()).toLocalDateTime());
                    row.setField(i2, (Object)ts);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (logicalType instanceof TinyIntType) {
                    row.setField(i2, (Object)BoxesRunTime.boxToByte((byte)r.getByte(i2)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (logicalType instanceof SmallIntType) {
                    row.setField(i2, (Object)BoxesRunTime.boxToShort((short)r.getShort(i2)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (logicalType instanceof IntType) {
                    row.setField(i2, (Object)BoxesRunTime.boxToInteger((int)r.getInt(i2)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (logicalType instanceof FloatType) {
                    row.setField(i2, (Object)BoxesRunTime.boxToFloat((float)r.getFloat(i2)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (logicalType instanceof MapType) {
                    BoxedUnit boxedUnit;
                    MapType mapType = (MapType)logicalType;
                    MapData mapData = r.getMap(i2);
                    if (mapData != null && mapData.size() > 0) {
                        LogicalType keyType = mapType.getKeyType();
                        LogicalType valueType = mapType.getValueType();
                        MapData mapData2 = mapData;
                        if (mapData2 instanceof BinaryMapData) {
                            BinaryMapData binaryMapData = (BinaryMapData)mapData2;
                            Tuple2<Object, Object> kvArray = this.toArray(keyType, valueType, binaryMapData);
                            HashMap map = new HashMap();
                            Predef$.MODULE$.genericArrayOps(kvArray._1()).indices().foreach((Function1 & Serializable & scala.Serializable)i -> ExecuteStatement.$anonfun$convertToRow$2(kvArray, map, BoxesRunTime.unboxToInt((Object)i)));
                            row.setField(i2, map);
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        } else if (mapData2 instanceof GenericMapData) {
                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)mapData2);
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        row.setField(i2, null);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit4 = boxedUnit;
                } else if (logicalType instanceof DoubleType) {
                    row.setField(i2, (Object)BoxesRunTime.boxToDouble((double)r.getDouble(i2)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (logicalType instanceof RowType) {
                    RowType rowType = (RowType)logicalType;
                    List fieldDataTypes = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)DynMethods.builder("getFieldDataTypes").impl(DataType.class, DataType.class).buildStatic().invoke(dataType)).asScala()).toList();
                    RowData internalRowData = r.getRow(i2, rowType.getFieldCount());
                    Row internalRow = this.convertToRow(internalRowData, (List<DataType>)fieldDataTypes);
                    row.setField(i2, (Object)internalRow);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String hiveString = RowSet$.MODULE$.toHiveString((Tuple2<Object, LogicalType>)new Tuple2(row.getField(i2), (Object)logicalType));
                    row.setField(i2, (Object)hiveString);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        });
        return var3_3;
    }

    private Tuple2<Object, Object> toArray(LogicalType keyType, LogicalType valueType, BinaryMapData arrayData) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)arrayData.keyArray().toObjectArray(keyType)), (Object)arrayData.valueArray().toObjectArray(valueType));
    }

    public static final /* synthetic */ Object $anonfun$runQueryOperation$1(ExecuteStatement $this, ArrayBuffer rows$1, ObjectRef resultId$1, List dataTypes$1, BooleanRef loop$1, int page) {
        BoxedUnit boxedUnit;
        if (rows$1.size() < $this.resultMaxRows) {
            DynMethods.BoundMethod retrieveResultPage = DynMethods.builder("retrieveResultPage").impl($this.executor().getClass(), String.class, Integer.TYPE).build($this.executor());
            Integer _page = page;
            if (FlinkEngineUtils$.MODULE$.isFlinkVersionEqualTo("1.14")) {
                java.util.List result = (java.util.List)retrieveResultPage.invoke((String)resultId$1.elem, _page);
                boxedUnit = rows$1.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(result).asScala());
            } else if (FlinkEngineUtils$.MODULE$.isFlinkVersionAtLeast("1.15")) {
                java.util.List result = (java.util.List)retrieveResultPage.invoke((String)resultId$1.elem, _page);
                boxedUnit = rows$1.$plus$plus$eq((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result).asScala()).map((Function1 & Serializable & scala.Serializable)r -> $this.convertToRow((RowData)r, (List<DataType>)dataTypes$1), Buffer$.MODULE$.canBuildFrom()));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            loop$1.elem = false;
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ Object $anonfun$convertToRow$2(Tuple2 kvArray$1, Map map$1, int i) {
        Object value = ScalaRunTime$.MODULE$.array_apply(kvArray$1._2(), i);
        return map$1.put(ScalaRunTime$.MODULE$.array_apply(kvArray$1._1(), i), value);
    }

    public ExecuteStatement(Session session, String statement, boolean shouldRunAsync, long queryTimeout, int resultMaxRows) {
        this.statement = statement;
        this.shouldRunAsync = shouldRunAsync;
        this.queryTimeout = queryTimeout;
        this.resultMaxRows = resultMaxRows;
        super(session);
        this.operationLog = OperationLog$.MODULE$.createOperationLog(session, this.getHandle());
        this.jobId = None$.MODULE$;
    }
}

