/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import jdbm.recman.BlockIo;
import jdbm.recman.RecordFile;
import org.apache.directory.server.i18n.I18n;

public final class TransactionManager {
    private RecordFile owner;
    private FileOutputStream fos;
    private ObjectOutputStream oos;
    static final int DEFAULT_TXNS_IN_LOG = 10;
    private int _maxTxns = 10;
    private ArrayList[] txns = new ArrayList[10];
    private int curTxn = -1;
    static final String extension = ".lg";

    TransactionManager(RecordFile owner) throws IOException {
        this.owner = owner;
        this.recover();
        this.open();
    }

    public void synchronizeLog() throws IOException {
        this.synchronizeLogFromMemory();
    }

    public void setMaximumTransactionsInLog(int maxTxns) throws IOException {
        if (maxTxns <= 0) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_563, (Object[])new Object[0]));
        }
        if (this.curTxn != -1) {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_564, (Object[])new Object[0]));
        }
        this._maxTxns = maxTxns;
        this.txns = new ArrayList[maxTxns];
    }

    private String makeLogName() {
        return this.owner.getFileName() + extension;
    }

    private void synchronizeLogFromMemory() throws IOException {
        this.close();
        TreeSet<BlockIo> blockList = new TreeSet<BlockIo>(new BlockIoComparator());
        for (int i = 0; i < this._maxTxns; ++i) {
            if (this.txns[i] == null) continue;
            for (BlockIo block : this.txns[i]) {
                if (blockList.contains(block)) {
                    block.decrementTransactionCount();
                    continue;
                }
                blockList.add(block);
            }
            this.txns[i] = null;
        }
        this.synchronizeBlocks(blockList.iterator(), true);
        this.owner.sync();
        this.open();
    }

    private void open() throws IOException {
        this.fos = new FileOutputStream(this.makeLogName());
        this.oos = new ObjectOutputStream(this.fos);
        this.oos.writeShort(4960);
        this.oos.flush();
        this.curTxn = -1;
    }

    private void recover() throws IOException {
        String logName = this.makeLogName();
        File logFile = new File(logName);
        if (!logFile.exists()) {
            return;
        }
        if (logFile.length() == 0L) {
            logFile.delete();
            return;
        }
        FileInputStream fis = new FileInputStream(logFile);
        ObjectInputStream ois = new ObjectInputStream(fis);
        try {
            if (ois.readShort() != 4960) {
                ois.close();
                throw new Error(I18n.err((I18n)I18n.ERR_565, (Object[])new Object[0]));
            }
        }
        catch (IOException e) {
            ois.close();
            logFile.delete();
            return;
        }
        while (true) {
            ArrayList blocks = null;
            try {
                blocks = (ArrayList)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                ois.close();
                throw new Error(I18n.err((I18n)I18n.ERR_566, (Object[])new Object[]{e}));
            }
            catch (IOException e) {
                break;
            }
            this.synchronizeBlocks(blocks.iterator(), false);
            try {
                ois = new ObjectInputStream(fis);
            }
            catch (IOException e) {
                break;
            }
        }
        this.owner.sync();
        ois.close();
        logFile.delete();
    }

    private void synchronizeBlocks(Iterator blockIterator, boolean fromCore) throws IOException {
        while (blockIterator.hasNext()) {
            BlockIo cur = (BlockIo)blockIterator.next();
            this.owner.sync(cur);
            if (!fromCore) continue;
            cur.decrementTransactionCount();
            if (cur.isInTransaction()) continue;
            this.owner.releaseFromTransaction(cur, true);
        }
    }

    private void setClean(ArrayList blocks) throws IOException {
        for (BlockIo cur : blocks) {
            cur.setClean();
        }
    }

    private void discardBlocks(ArrayList blocks) throws IOException {
        for (BlockIo cur : blocks) {
            cur.decrementTransactionCount();
            if (cur.isInTransaction()) continue;
            this.owner.releaseFromTransaction(cur, false);
        }
    }

    void start() throws IOException {
        ++this.curTxn;
        if (this.curTxn == this._maxTxns) {
            this.synchronizeLogFromMemory();
            this.curTxn = 0;
        }
        this.txns[this.curTxn] = new ArrayList();
    }

    void add(BlockIo block) throws IOException {
        block.incrementTransactionCount();
        this.txns[this.curTxn].add(block);
    }

    void commit() throws IOException {
        this.oos.writeObject(this.txns[this.curTxn]);
        this.sync();
        this.setClean(this.txns[this.curTxn]);
        this.oos = new ObjectOutputStream(this.fos);
        this.oos.reset();
    }

    private void sync() throws IOException {
        this.oos.flush();
        this.fos.flush();
        this.fos.getFD().sync();
    }

    void shutdown() throws IOException {
        this.synchronizeLogFromMemory();
        this.close();
    }

    private void close() throws IOException {
        this.sync();
        this.oos.close();
        this.fos.close();
        this.oos = null;
        this.fos = null;
    }

    void forceClose() throws IOException {
        this.oos.close();
        this.fos.close();
        this.oos = null;
        this.fos = null;
    }

    void synchronizeLogFromDisk() throws IOException {
        this.close();
        for (int i = 0; i < this._maxTxns; ++i) {
            if (this.txns[i] == null) continue;
            this.discardBlocks(this.txns[i]);
            this.txns[i] = null;
        }
        this.recover();
        this.open();
    }

    public static class BlockIoComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            BlockIo block1 = (BlockIo)o1;
            BlockIo block2 = (BlockIo)o2;
            int result = 0;
            result = block1.getBlockId() == block2.getBlockId() ? 0 : (block1.getBlockId() < block2.getBlockId() ? -1 : 1);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

