/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.search.entry;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchResultEntryDecorator;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchResultEntryObjectName
extends GrammarAction<LdapMessageContainer<SearchResultEntryDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchResultEntryObjectName.class);

    public StoreSearchResultEntryObjectName() {
        super("Store SearchResultEntry name");
    }

    public void action(LdapMessageContainer<SearchResultEntryDecorator> container) throws DecoderException {
        SearchResultEntryDecorator searchResultEntry = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Dn objectName = Dn.EMPTY_DN;
        if (tlv.getLength() == 0) {
            searchResultEntry.setObjectName(objectName);
        } else {
            byte[] dnBytes = tlv.getValue().getData();
            String dnStr = Strings.utf8ToString((byte[])dnBytes);
            try {
                objectName = new Dn(new String[]{dnStr});
            }
            catch (LdapInvalidDnException ine) {
                String msg = I18n.err((I18n)I18n.ERR_05157_INVALID_DN, (Object[])new Object[]{Strings.dumpBytes((byte[])dnBytes), ine.getMessage()});
                LOG.error(I18n.err((I18n)I18n.ERR_05114_ERROR_MESSAGE, (Object[])new Object[]{msg, ine.getMessage()}));
                throw new DecoderException(msg, (Throwable)ine);
            }
            searchResultEntry.setObjectName(objectName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05182_SEARCH_RESULT_ENTRY_DN, (Object[])new Object[]{searchResultEntry.getObjectName()}));
        }
    }
}

