/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.GatewayFactory;
import org.apache.knox.gateway.GatewayFilter;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.descriptor.GatewayDescriptor;
import org.apache.knox.gateway.descriptor.GatewayDescriptorFactory;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.metrics.MetricsService;

public class GatewayServlet
implements Servlet,
Filter {
    public static final String GATEWAY_DESCRIPTOR_LOCATION_DEFAULT = "gateway.xml";
    public static final String GATEWAY_DESCRIPTOR_LOCATION_PARAM = "gatewayDescriptorLocation";
    private static final GatewayResources res = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = AuditServiceFactory.getAuditService().getAuditor("audit", "knox", "knox");
    private FilterConfigAdapter filterConfig = null;
    private GatewayFilter filter;

    public GatewayServlet(GatewayFilter filter) {
        this.filter = filter;
    }

    public GatewayServlet() {
        this(null);
    }

    public synchronized GatewayFilter getFilter() {
        return this.filter;
    }

    public synchronized void setFilter(GatewayFilter filter) throws ServletException {
        if (this.filterConfig != null) {
            filter.init(this.filterConfig);
        }
        this.filter = filter;
        if (filter != null && this.filterConfig != null) {
            filter.destroy();
        }
    }

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        try {
            if (this.filter == null) {
                this.filter = GatewayServlet.createFilter(servletConfig);
            }
            this.filterConfig = new FilterConfigAdapter(servletConfig);
            if (this.filter != null) {
                this.filter.init(this.filterConfig);
            }
        }
        catch (RuntimeException | ServletException e) {
            LOG.failedToInitializeServletInstace((Exception)e);
            throw e;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            if (this.filter == null) {
                this.filter = GatewayServlet.createFilter(filterConfig);
            }
            if (this.filter != null) {
                this.filter.init(filterConfig);
            }
        }
        catch (RuntimeException | ServletException e) {
            LOG.failedToInitializeServletInstace((Exception)e);
            throw e;
        }
    }

    public ServletConfig getServletConfig() {
        return this.filterConfig.getServletConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        try {
            auditService.createContext();
            GatewayFilter f = this.filter;
            if (f != null) {
                try {
                    f.doFilter(servletRequest, servletResponse, null);
                }
                catch (IOException | RuntimeException | ServletException e) {
                    LOG.failedToExecuteFilter(e);
                    throw e;
                }
            } else {
                ((HttpServletResponse)servletResponse).setStatus(503);
            }
            String requestUri = (String)servletRequest.getAttribute("sourceRequestContextUrl");
            int status = ((HttpServletResponse)servletResponse).getStatus();
            auditor.audit("access", requestUri, "uri", "success", res.responseStatus(status));
        }
        finally {
            auditService.detachContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        try {
            GatewayServlet.auditService.createContext();
            f = this.filter;
            if (f != null) {
                try {
                    f.doFilter(servletRequest, servletResponse);
                    if (servletResponse.isCommitted()) ** GOTO lbl15
                    chain.doFilter(servletRequest, servletResponse);
                }
                catch (IOException | RuntimeException | ServletException e) {
                    GatewayServlet.LOG.failedToExecuteFilter(e);
                    throw e;
                }
            } else {
                ((HttpServletResponse)servletResponse).setStatus(503);
            }
lbl15:
            // 3 sources

            requestUri = (String)servletRequest.getAttribute("sourceRequestContextUrl");
            status = ((HttpServletResponse)servletResponse).getStatus();
            GatewayServlet.auditor.audit("access", requestUri, "uri", "success", GatewayServlet.res.responseStatus(status));
        }
        finally {
            GatewayServlet.auditService.detachContext();
        }
    }

    public String getServletInfo() {
        return res.gatewayServletInfo();
    }

    public synchronized void destroy() {
        if (this.filter != null) {
            this.filter.destroy();
        }
        this.filter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GatewayFilter createFilter(InputStream stream, ServletContext servletContext) throws ServletException {
        try {
            GatewayFilter instrumentedFilter;
            GatewayServices gatewayServices;
            MetricsService metricsService;
            GatewayConfig gatewayConfig;
            GatewayFilter filter = null;
            if (stream != null) {
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    GatewayDescriptor descriptor = GatewayDescriptorFactory.load("xml", reader);
                    filter = GatewayFactory.create(descriptor);
                }
                finally {
                    stream.close();
                }
            }
            if ((gatewayConfig = (GatewayConfig)servletContext.getAttribute("org.apache.knox.gateway.config")).isMetricsEnabled() && (metricsService = (MetricsService)(gatewayServices = (GatewayServices)servletContext.getAttribute("org.apache.knox.gateway.gateway.services")).getService(ServiceType.METRICS_SERVICE)) != null && (instrumentedFilter = (GatewayFilter)metricsService.getInstrumented((Object)filter)) != null) {
                filter = instrumentedFilter;
            }
            return filter;
        }
        catch (IOException | URISyntaxException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private static GatewayFilter createFilter(FilterConfig filterConfig) throws ServletException {
        InputStream stream;
        String location = filterConfig.getInitParameter(GATEWAY_DESCRIPTOR_LOCATION_PARAM);
        if (location != null) {
            stream = filterConfig.getServletContext().getResourceAsStream(location);
            if (stream == null) {
                stream = filterConfig.getServletContext().getResourceAsStream("/WEB-INF/" + location);
            }
        } else {
            stream = filterConfig.getServletContext().getResourceAsStream(GATEWAY_DESCRIPTOR_LOCATION_DEFAULT);
        }
        GatewayFilter filter = GatewayServlet.createFilter(stream, filterConfig.getServletContext());
        return filter;
    }

    private static GatewayFilter createFilter(ServletConfig servletConfig) throws ServletException {
        InputStream stream;
        String location = servletConfig.getInitParameter(GATEWAY_DESCRIPTOR_LOCATION_PARAM);
        if (location != null) {
            stream = servletConfig.getServletContext().getResourceAsStream(location);
            if (stream == null) {
                stream = servletConfig.getServletContext().getResourceAsStream("/WEB-INF/" + location);
            }
        } else {
            stream = servletConfig.getServletContext().getResourceAsStream(GATEWAY_DESCRIPTOR_LOCATION_DEFAULT);
        }
        GatewayFilter filter = GatewayServlet.createFilter(stream, servletConfig.getServletContext());
        return filter;
    }

    private static class FilterConfigAdapter
    implements FilterConfig {
        private ServletConfig config;

        FilterConfigAdapter(ServletConfig config) {
            this.config = config;
        }

        private ServletConfig getServletConfig() {
            return this.config;
        }

        public String getFilterName() {
            return this.config.getServletName();
        }

        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }

        public String getInitParameter(String name) {
            return this.config.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.config.getInitParameterNames();
        }
    }
}

